<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: Wiki.php 66110 2018-04-19 18:22:38Z luciash $

class TikiWebdav_PathFactories_Wiki implements ezcWebdavPathFactory
{
	protected $baseUri = '';
	protected $baseUriLength = 0;
	protected $collectionPathes = [];

	public function parseUriToPath($uri)
	{
		$requestPath = rawurldecode(trim($uri));

		if (empty($requestPath)) {
			$requestPath = '/';
		} elseif (substr($requestPath, -1, 1) === '/') {
			$this->collectionPathes[substr($requestPath, 0, -1)] = true;
		}

		return $requestPath;
	}

	public function generateUriFromPath($path)
	{
		global $base_url;

		$result = $base_url . 'tiki-webdav.php/Wiki%20Pages' . implode('/', array_map('rawurlencode', explode('/', $path)));

		print_debug("generateUriFromPath($path): $result\n");
		return $result;
	}
}
