<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: Token.php 66104 2018-04-19 18:09:02Z luciash $

class Search_Expr_Token implements Search_Expr_Interface
{
	private $string;
	private $type;
	private $field;
	private $weight;

	function __construct($string, $type = null, $field = null, $weight = 1.0)
	{
		$this->string = $string;
		$this->type = $type;
		$this->field = $field;
		$this->setWeight($weight);
	}

	function setType($type)
	{
		$this->type = $type;
	}

	function getType()
	{
		return $this->type;
	}

	function setField($field = 'global')
	{
		$this->field = $field;
	}

	function setWeight($weight)
	{
		$this->weight = (float) $weight;
	}

	function getWeight()
	{
		return $this->weight;
	}

	function walk($callback)
	{
		return call_user_func($callback, $this, []);
	}

	function getValue(Search_Type_Factory_Interface $typeFactory)
	{
		$type = $this->type;
		return $typeFactory->$type($this->string);
	}

	function getField()
	{
		return $this->field;
	}

	function traverse($callback)
	{
		return call_user_func($callback, $callback, $this, []);
	}
}
