<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: Function.php 66107 2018-04-19 18:14:47Z luciash $

abstract class Math_Formula_Function
{
	private $callback;

	function evaluateTemplate($element, $evaluateCallback)
	{
		$this->callback = $evaluateCallback;
		return $this->evaluate($element);
	}

	abstract function evaluate($element);

	protected function evaluateChild($child, array $extraVariables = [])
	{
		return call_user_func($this->callback, $child, $extraVariables);
	}

	protected function error($message)
	{
		throw new Math_Formula_Exception($message);
	}
}
