<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: profiles_useful_admin_confs.php 66110 2018-04-19 18:22:38Z luciash $

require_once('lib/wizard/wizard.php');

/**
 * Show the profiles choices
 */
class ProfilesWizardUsefulAdminConfs extends Wizard
{
	function pageTitle()
	{
		return tra('Useful Administration Configurations');
	}
	function isEditable()
	{
		return false;
	}

	function onSetupPage($homepageUrl)
	{
		global $prefs, $TWV;
		// Run the parent first
		parent::onSetupPage($homepageUrl);

		$smarty = TikiLib::lib('smarty');
		$smarty->assign('tikiMajorVersion', substr($TWV->version, 0, 2));

		return true;
	}

	function getTemplate()
	{
		$wizardTemplate = 'wizard/profiles_useful_admin_confs.tpl';
		return $wizardTemplate;
	}

	function onContinue($homepageUrl)
	{
		// Run the parent first
		parent::onContinue($homepageUrl);
	}
}
