<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platfroms allow them to do with
// text.
//
// Copyright (C) 2006-2017  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Type;

/**
 * @package Kaltura
 * @subpackage Client
 */
class ConvertCollectionFlavorData extends \Kaltura\Client\ObjectBase
{
	public function getKalturaObjectType()
	{
		return 'KalturaConvertCollectionFlavorData';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->flavorAssetId))
			$this->flavorAssetId = (string)$xml->flavorAssetId;
		if(count($xml->flavorParamsOutputId))
			$this->flavorParamsOutputId = (int)$xml->flavorParamsOutputId;
		if(count($xml->readyBehavior))
			$this->readyBehavior = (int)$xml->readyBehavior;
		if(count($xml->videoBitrate))
			$this->videoBitrate = (int)$xml->videoBitrate;
		if(count($xml->audioBitrate))
			$this->audioBitrate = (int)$xml->audioBitrate;
		if(count($xml->destFileSyncLocalPath))
			$this->destFileSyncLocalPath = (string)$xml->destFileSyncLocalPath;
		if(count($xml->destFileSyncRemoteUrl))
			$this->destFileSyncRemoteUrl = (string)$xml->destFileSyncRemoteUrl;
	}
	/**
	 * 
	 * @var string
	 */
	public $flavorAssetId = null;

	/**
	 * 
	 * @var int
	 */
	public $flavorParamsOutputId = null;

	/**
	 * 
	 * @var int
	 */
	public $readyBehavior = null;

	/**
	 * 
	 * @var int
	 */
	public $videoBitrate = null;

	/**
	 * 
	 * @var int
	 */
	public $audioBitrate = null;

	/**
	 * 
	 * @var string
	 */
	public $destFileSyncLocalPath = null;

	/**
	 * 
	 * @var string
	 */
	public $destFileSyncRemoteUrl = null;

}
