<?php
/**
 * File containing the ezcWebdavPropStatResponse class.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package Webdav
 * @version //autogentag//
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 */
/**
 * Class generated by the backend to respond to PROPSTAT requests.
 *
 * If a {@link ezcWebdavBackend} receives an instance of {@link
 * ezcWebdavPropStatRequest} it might react with an instance of {@link
 * ezcWebdavPropStatResponse} or with producing an error.
 *
 * @version //autogentag//
 * @package Webdav
 */
class ezcWebdavPropStatResponse extends ezcWebdavResponse
{
    /**
     * Creates a new response object.
     *
     * Creates PROPSTAT response, which will be aggregated in a {@link
     * ezcWebdavPropFindResponse} from a property storage ($storage) and
     * optionally an error stutus code, which will default to 200(OK).
     * 
     * @param ezcWebdavPropertyStorage $storage
     * @param int $status 
     * @return void
     */
    public function __construct( ezcWebdavPropertyStorage $storage, $status = ezcWebdavResponse::STATUS_200 )
    {
        parent::__construct( $status );

        $this->storage = $storage;
    }

    /**
     * Sets a property.
     *
     * This method is called when an property is to be set.
     * 
     * @param string $propertyName The name of the property to set.
     * @param mixed $propertyValue The property value.
     * @return void
     * @ignore
     *
     * @throws ezcBasePropertyNotFoundException
     *         if the given property does not exist.
     * @throws ezcBaseValueException
     *         if the value to be assigned to a property is invalid.
     * @throws ezcBasePropertyPermissionException
     *         if the property to be set is a read-only property.
     */
    public function __set( $propertyName, $propertyValue )
    {
        switch ( $propertyName )
        {
            case 'storage':
                if ( ! $propertyValue instanceof ezcWebdavPropertyStorage )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'ezcWebdavPropertyStorage' );
                }

                $this->properties[$propertyName] = $propertyValue;
                break;

            default:
                parent::__set( $propertyName, $propertyValue );
        }
    }
}

?>
