<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: block.accordion.php 67214 2018-08-16 08:15:44Z chibaguy $

/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 *
 * \brief smarty_block_tabs : add tabs to a template
 *
 * params: name (optional but unique per page if set)
 * params: toggle=y on n default
 *
 * usage:
 * \code
 *	{accordion}
 * 		{accordion_group title="{tr}Title 1{/tr}"}tab content{/accordion_group}
 * 		{accordion_group title="{tr}Title 2{/tr}"}tab content{/accordion_group}
 *	{/accordion}
 * \endcode
 */

//this script may only be included - so its better to die if called directly.
if (strpos($_SERVER["SCRIPT_NAME"], basename(__FILE__)) !== false) {
	header("location: index.php");
	exit;
}

function smarty_block_accordion($params, $content, $smarty, &$repeat)
{
	global $accordion_current_group;

	if ($repeat) {
		$accordion_current_group = null;
		return;
	} else {
		return <<<CONTENT
<div class="accordian" id="$accordion_current_group">
$content
</div>
CONTENT;
	}
}
