# git sed

> git으로 관리되는 파일에서 sed를 사용하여 패턴을 대체.
> `git-extras`의 일부.
> 더 많은 정보: <https://manned.org/git-sed>.

- 현재 저장소에서 지정된 텍스트 대체:

`git sed '{{찾을_텍스트}}' '{{대체할_텍스트}}'`

- 지정된 텍스트를 대체한 후, 표준 커밋 메시지로 결과 변경사항 커밋:

`git sed -c '{{찾을_텍스트}}' '{{대체할_텍스트}}'`

- 정규 표현식을 사용하여 지정된 텍스트 대체:

`git sed -f g '{{찾을_텍스트}}' '{{대체할_텍스트}}'`

- 주어진 디렉터리 내 모든 파일에서 특정 텍스트 대체:

`git sed '{{찾을_텍스트}}' '{{대체할_텍스트}}' -- {{경로/대상/폴더}}`
