/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.cmdline;

import com.trollworks.ttk.cmdline.CmdLineData;
import com.trollworks.ttk.cmdline.CmdLineOption;
import com.trollworks.ttk.text.TextUtility;
import com.trollworks.ttk.utility.App;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Platform;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class CmdLine {
    private static String MSG_AVAILABLE_OPTIONS;
    private static String MSG_UNEXPECTED_OPTION;
    private static String MSG_UNEXPECTED_OPTION_ARGUMENT;
    private static String MSG_MISSING_OPTION_ARGUMENT;
    private static String MSG_HELP_DESCRIPTION;
    private static String MSG_VERSION_DESCRIPTION;
    private static String MSG_REFERENCE_DESCRIPTION;
    private static final CmdLineOption HELP_OPTION;
    private static final CmdLineOption VERSION_OPTION;
    private ArrayList<CmdLineData> mData;
    private HashSet<CmdLineOption> mUsedOptions;

    public CmdLine(String[] stringArray) {
        this(stringArray, null, new ArrayList<CmdLineOption>());
    }

    public CmdLine(String[] stringArray, CmdLineOption ... cmdLineOptionArray) {
        this(stringArray, null, Arrays.asList(cmdLineOptionArray));
    }

    public CmdLine(String[] stringArray, Collection<CmdLineOption> collection) {
        this(stringArray, null, collection);
    }

    public CmdLine(String[] stringArray, String string, Collection<CmdLineOption> collection) {
        HashMap<String, CmdLineOption> hashMap = new HashMap<String, CmdLineOption>();
        ArrayList<CmdLineOption> arrayList = new ArrayList<CmdLineOption>(collection);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(HELP_OPTION);
        arrayList.add(VERSION_OPTION);
        for (CmdLineOption object : arrayList) {
            for (String string2 : object.getNames()) {
                hashMap.put(string2, object);
            }
        }
        this.mData = new ArrayList();
        this.mUsedOptions = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (i == 0 && Platform.isMacintosh() && stringArray[i].startsWith("-psn_")) continue;
            if (this.hasOptionPrefix(string3)) {
                String string2;
                String string4 = string3.substring(string3.startsWith("--") ? 2 : 1);
                String string5 = string4.toLowerCase();
                int n = string5.indexOf(61);
                if (n != -1) {
                    string2 = string4.substring(n + 1);
                    string5 = string5.substring(0, n);
                } else {
                    string2 = null;
                }
                CmdLineOption cmdLineOption = hashMap.get(string5);
                if (cmdLineOption != null) {
                    if (cmdLineOption.takesArgument()) {
                        if (string2 != null) {
                            this.mData.add(new CmdLineData(cmdLineOption, string2));
                            this.mUsedOptions.add(cmdLineOption);
                            continue;
                        }
                        if (++i < stringArray.length) {
                            string2 = stringArray[i];
                            if (this.hasOptionPrefix(string2)) {
                                arrayList2.add(MessageFormat.format(MSG_MISSING_OPTION_ARGUMENT, string3));
                                --i;
                                continue;
                            }
                            this.mData.add(new CmdLineData(cmdLineOption, string2));
                            this.mUsedOptions.add(cmdLineOption);
                            continue;
                        }
                        arrayList2.add(MessageFormat.format(MSG_MISSING_OPTION_ARGUMENT, string3));
                        continue;
                    }
                    if (string2 != null) {
                        arrayList2.add(MessageFormat.format(MSG_UNEXPECTED_OPTION_ARGUMENT, string3));
                        continue;
                    }
                    this.mData.add(new CmdLineData(cmdLineOption));
                    this.mUsedOptions.add(cmdLineOption);
                    continue;
                }
                arrayList2.add(MessageFormat.format(MSG_UNEXPECTED_OPTION, string3));
                continue;
            }
            this.mData.add(new CmdLineData(string3));
        }
        if (this.mUsedOptions.contains(HELP_OPTION)) {
            this.showHelp(hashMap, string);
        }
        if (this.mUsedOptions.contains(VERSION_OPTION)) {
            System.out.println();
            System.out.println(App.getVersionBanner(false));
            System.out.println();
            System.exit(0);
        }
        if (!arrayList2.isEmpty()) {
            for (String string6 : arrayList2) {
                System.out.println(string6);
            }
            System.exit(1);
        }
    }

    private boolean hasOptionPrefix(String string) {
        return string.startsWith("-") || Platform.isWindows() && string.startsWith("/");
    }

    private void showHelp(HashMap<String, CmdLineOption> hashMap, String string) {
        CmdLineOption cmdLineOption;
        ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
        int n = 0;
        Collections.sort(arrayList);
        System.out.println();
        System.out.println(App.getVersionBanner(false));
        System.out.println();
        System.out.println(MSG_AVAILABLE_OPTIONS);
        System.out.println();
        for (String string2 : arrayList) {
            cmdLineOption = hashMap.get(string2);
            int n2 = 5 + string2.length();
            if (cmdLineOption.takesArgument()) {
                n2 += 1 + cmdLineOption.getArgumentLabel().length();
            }
            if (n2 <= n) continue;
            n = n2;
        }
        for (String string2 : arrayList) {
            cmdLineOption = hashMap.get(string2);
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = cmdLineOption.getNames();
            String string3 = Platform.isWindows() ? "/" : "-";
            String string4 = stringArray[stringArray.length - 1].equals(string2) ? cmdLineOption.getDescription() : MessageFormat.format(MSG_REFERENCE_DESCRIPTION, string3, stringArray[stringArray.length - 1]);
            stringBuilder.append("  ");
            stringBuilder.append(string3);
            stringBuilder.append(string2);
            if (cmdLineOption.takesArgument()) {
                stringBuilder.append('=');
                stringBuilder.append(cmdLineOption.getArgumentLabel());
            }
            stringBuilder.append(TextUtility.makeFiller(n - stringBuilder.length(), ' '));
            System.out.print(TextUtility.makeNote(stringBuilder.toString(), TextUtility.wrapToCharacterCount(string4, 75 - n)));
        }
        if (string != null) {
            System.out.println();
            System.out.println(string);
        }
        System.out.println();
        System.exit(0);
    }

    public boolean isOptionUsed(CmdLineOption cmdLineOption) {
        return this.mUsedOptions.contains(cmdLineOption);
    }

    public String getOptionArgument(CmdLineOption cmdLineOption) {
        if (this.isOptionUsed(cmdLineOption)) {
            for (CmdLineData cmdLineData : this.mData) {
                if (!cmdLineData.isOption() || cmdLineData.getOption() != cmdLineOption) continue;
                return cmdLineData.getArgument();
            }
        }
        return null;
    }

    public ArrayList<String> getOptionArguments(CmdLineOption cmdLineOption) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isOptionUsed(cmdLineOption)) {
            for (CmdLineData cmdLineData : this.mData) {
                if (!cmdLineData.isOption() || cmdLineData.getOption() != cmdLineOption) continue;
                arrayList.add(cmdLineData.getArgument());
            }
        }
        return arrayList;
    }

    public ArrayList<String> getArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CmdLineData cmdLineData : this.mData) {
            if (cmdLineData.isOption()) continue;
            arrayList.add(cmdLineData.getArgument());
        }
        return arrayList;
    }

    public ArrayList<File> getArgumentsAsFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (CmdLineData cmdLineData : this.mData) {
            if (cmdLineData.isOption()) continue;
            arrayList.add(new File(cmdLineData.getArgument()));
        }
        return arrayList;
    }

    static {
        LocalizedMessages.initialize(CmdLine.class);
        HELP_OPTION = new CmdLineOption(MSG_HELP_DESCRIPTION, null, "h", "?", "help");
        VERSION_OPTION = new CmdLineOption(MSG_VERSION_DESCRIPTION, null, "v", "version");
    }
}

