/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.image;

import com.trollworks.ttk.image.Images;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class ColorFilter
extends RGBImageFilter {
    private static final int OPAQUE = -16777216;
    private int mRed;
    private int mGreen;
    private int mBlue;
    private boolean mIncludeAlpha;

    public ColorFilter(Color color) {
        this(color, false);
    }

    public ColorFilter(Color color, boolean bl) {
        this.mRed = color.getRed();
        this.mGreen = color.getGreen();
        this.mBlue = color.getBlue();
        this.mIncludeAlpha = bl;
        this.canFilterIndexColorModel = true;
    }

    public static BufferedImage createColorizedImage(BufferedImage bufferedImage, Color color) {
        return ColorFilter.createColorizedImage(bufferedImage, color, false);
    }

    public static BufferedImage createColorizedImage(BufferedImage bufferedImage, Color color, boolean bl) {
        ColorFilter colorFilter = new ColorFilter(color, bl);
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), colorFilter);
        return Images.getBufferedImage(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        if (this.mIncludeAlpha || (n3 & 0xFF000000) == -16777216) {
            int n4 = (int)(((double)(n3 >> 16 & 0xFF) * 0.3 + (double)(n3 >> 8 & 0xFF) * 0.59 + (double)(n3 & 0xFF) * 0.11) / 2.55);
            n3 = n3 & 0xFF000000 | this.mRed * n4 / 100 << 16 | this.mGreen * n4 / 100 << 8 | this.mBlue * n4 / 100;
        }
        return n3;
    }
}

