/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.image;

import com.trollworks.ttk.image.Images;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class FadeFilter
extends RGBImageFilter {
    private static final int OPAQUE = -16777216;
    private int mPercentage;
    private boolean mUseWhite;

    public FadeFilter(int n, boolean bl) {
        this.mPercentage = n;
        this.mUseWhite = bl;
        this.canFilterIndexColorModel = true;
    }

    public static BufferedImage createFadedImage(BufferedImage bufferedImage, int n, boolean bl) {
        FadeFilter fadeFilter = new FadeFilter(n, bl);
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), fadeFilter);
        return Images.getBufferedImage(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 >> 16 & 0xFF;
        int n5 = n3 >> 8 & 0xFF;
        int n6 = n3 & 0xFF;
        int n7 = 100 - this.mPercentage;
        int n8 = this.mUseWhite ? 255 * this.mPercentage : 0;
        n4 = (n4 * n7 + n8) / 100;
        n5 = (n5 * n7 + n8) / 100;
        n6 = (n6 * n7 + n8) / 100;
        return n3 & 0xFF000000 | n4 << 16 | n5 << 8 | n6;
    }
}

