/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import com.trollworks.ttk.layout.FlexCell;
import com.trollworks.ttk.layout.FlexComponent;
import com.trollworks.ttk.layout.FlexContainer;
import com.trollworks.ttk.layout.FlexGridData;
import com.trollworks.ttk.layout.LayoutSize;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class FlexGrid
extends FlexContainer {
    private HashMap<FlexCell, FlexGridData> mData = new HashMap();
    private int mColumns = 1;
    private int mRows = 1;
    private FlexGridData[][] mGrid;
    private int[] mColumnWidths;
    private int[] mMinColumnWidths;
    private int[] mMaxColumnWidths;
    private int[] mRowHeights;
    private int[] mMinRowHeights;
    private int[] mMaxRowHeights;
    private TreeMap<Integer, ArrayList<FlexGridData>> mRowSpanMap;
    private TreeMap<Integer, ArrayList<FlexGridData>> mColumnSpanMap;

    public int getColumnCount() {
        return this.mColumns;
    }

    public int getRowCount() {
        return this.mRows;
    }

    @Override
    public void add(Component component) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(FlexCell flexCell) {
        throw new UnsupportedOperationException();
    }

    public void add(Component component, int n, int n2) {
        this.add(component, n, n2, 1, 1);
    }

    public void add(Component component, int n, int n2, int n3, int n4) {
        this.add(new FlexComponent(component), n, n2, n3, n4);
    }

    public void add(FlexCell flexCell, int n, int n2) {
        this.add(flexCell, n, n2, 1, 1);
    }

    public void add(FlexCell flexCell, int n, int n2, int n3, int n4) {
        super.add(flexCell);
        FlexGridData flexGridData = new FlexGridData(flexCell, n, n2, n3, n4);
        this.mData.put(flexCell, flexGridData);
        n = flexGridData.getLastRow() + 1;
        if (n > this.mRows) {
            this.mRows = n;
        }
        if ((n2 = flexGridData.getLastColumn() + 1) > this.mColumns) {
            this.mColumns = n2;
        }
    }

    private int updateStarts(int n, int[] nArray, int[] nArray2) {
        int n2 = n;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = n2;
            n2 += nArray[i];
        }
        return n2 - n;
    }

    private void grow(int n, int[] nArray, int[] nArray2, boolean bl) {
        int n2;
        int n3 = 1 + (nArray.length - 1) / 2;
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray3[n2] = nArray[n2 * 2];
            nArray4[n2] = nArray2[n2 * 2];
        }
        n = this.distribute(n, nArray3, nArray4);
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2 * 2] = nArray3[n2];
        }
        if (n > 0 && bl) {
            n3 = 1 + (nArray.length - 1) / 2;
            while (n > 0) {
                n2 = n / n3;
                if (n2 < 1) {
                    n2 = 1;
                }
                for (int i = 0; i <= nArray.length && n > 0; n -= n2, i += 2) {
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n2;
                    int n5 = i;
                    nArray2[n5] = nArray2[n5] + n2;
                }
            }
        }
    }

    private void shrink(int n, int[] nArray, int[] nArray2) {
        int n2;
        int n3 = 1 + (nArray.length - 1) / 2;
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray3[n2] = nArray[n2 * 2];
            nArray4[n2] = nArray2[n2 * 2];
        }
        n = this.distribute(-n, nArray3, nArray4);
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2 * 2] = nArray3[n2];
        }
        if (n < 0) {
            n3 = 1 + (nArray.length - 1) / 2;
            while (n > 0 && n3 > 0) {
                n2 = n / n3;
                if (n2 > -1) {
                    n2 = -1;
                }
                n3 = 0;
                for (int i = 0; i <= nArray.length && n < 0; i += 2) {
                    if (nArray[i] <= 0) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n2;
                    int n5 = i;
                    nArray2[n5] = nArray2[n5] + n2;
                    n += n2;
                    ++n3;
                }
            }
        }
    }

    @Override
    protected void layoutSelf(Rectangle rectangle) {
        int[] nArray;
        int n;
        this.createGrid(LayoutSize.PREFERRED);
        int[] nArray2 = new int[this.mColumns];
        int n2 = this.updateStarts(rectangle.x, this.mColumnWidths, nArray2);
        int n3 = rectangle.width - n2;
        if (n3 != 0) {
            if (n3 > 0) {
                this.grow(n3, this.mColumnWidths, this.mMaxColumnWidths, this.getFillHorizontal());
            } else {
                this.shrink(-n3, this.mColumnWidths, this.mMinColumnWidths);
            }
            n2 = this.updateStarts(rectangle.x, this.mColumnWidths, nArray2);
        }
        if ((n3 = rectangle.height - (n = this.updateStarts(rectangle.y, this.mRowHeights, nArray = new int[this.mRows]))) != 0) {
            if (n3 > 0) {
                this.grow(n3, this.mRowHeights, this.mMaxRowHeights, this.getFillVertical());
            } else {
                this.shrink(-n3, this.mRowHeights, this.mMinRowHeights);
            }
            n = this.updateStarts(rectangle.y, this.mRowHeights, nArray);
        }
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(this.getChildCount());
        for (FlexCell flexCell : this.getChildren()) {
            int n4;
            FlexGridData flexGridData = this.mData.get(flexCell);
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = nArray2[flexGridData.mColumn];
            rectangle2.y = nArray[flexGridData.mRow];
            int n5 = flexGridData.getLastColumn();
            n2 = 0;
            for (n4 = flexGridData.mColumn; n4 <= n5; ++n4) {
                n2 += this.mColumnWidths[n4];
            }
            rectangle2.width = n2;
            n5 = flexGridData.getLastRow();
            n = 0;
            for (n4 = flexGridData.mRow; n4 <= n5; ++n4) {
                n += this.mRowHeights[n4];
            }
            rectangle2.height = n;
            arrayList.add(rectangle2);
        }
        this.flush();
        this.layoutChildren(arrayList.toArray(new Rectangle[arrayList.size()]));
    }

    @Override
    protected Dimension getSizeSelf(LayoutSize layoutSize) {
        int n;
        this.createGrid(layoutSize);
        int n2 = 0;
        for (n = 0; n < this.mColumns; ++n) {
            n2 += this.mColumnWidths[n];
        }
        n = 0;
        for (int i = 0; i < this.mRows; ++i) {
            n += this.mRowHeights[i];
        }
        this.flush();
        return new Dimension(n2, n);
    }

    private void flush() {
        this.mGrid = null;
        this.mColumnWidths = null;
        this.mMinColumnWidths = null;
        this.mMaxColumnWidths = null;
        this.mRowHeights = null;
        this.mMinRowHeights = null;
        this.mMaxRowHeights = null;
        this.mRowSpanMap = null;
        this.mColumnSpanMap = null;
    }

    private void createGrid(LayoutSize layoutSize) {
        int n;
        this.mGrid = new FlexGridData[this.mRows][this.mColumns];
        this.mColumnWidths = new int[this.mColumns];
        this.mMinColumnWidths = new int[this.mColumns];
        this.mMaxColumnWidths = new int[this.mColumns];
        this.mRowHeights = new int[this.mRows];
        this.mMinRowHeights = new int[this.mRows];
        this.mMaxRowHeights = new int[this.mRows];
        this.mRowSpanMap = new TreeMap();
        this.mColumnSpanMap = new TreeMap();
        for (n = 0; n < this.mColumns; ++n) {
            this.mMaxColumnWidths[n] = 0x3FFFFF;
        }
        for (n = 0; n < this.mRows; ++n) {
            this.mMaxRowHeights[n] = 0x3FFFFF;
        }
        for (Map.Entry<FlexCell, FlexGridData> entry : this.mData.entrySet()) {
            FlexCell flexCell = entry.getKey();
            FlexGridData flexGridData = entry.getValue();
            for (int i = 0; i < flexGridData.mRowSpan; ++i) {
                for (int j = 0; j < flexGridData.mColumnSpan; ++j) {
                    int n2 = flexGridData.mRow + i;
                    int n3 = flexGridData.mColumn + j;
                    if (this.mGrid[n2][n3] != null) {
                        throw new InvalidParameterException(flexGridData + ": " + FlexGridData.formatRowColumn(n2 / 2, n3 / 2, false) + " already occupied by " + this.mData.get(this.mGrid[n2][n3]));
                    }
                    this.mGrid[n2][n3] = flexGridData;
                }
            }
            flexGridData.mSize = flexCell.getSize(layoutSize);
            flexGridData.mMinSize = flexCell.getSize(LayoutSize.MINIMUM);
            flexGridData.mMaxSize = flexCell.getSize(LayoutSize.MAXIMUM);
            this.updateRowColumnSizes(flexGridData);
            this.addToSpanMap(flexGridData.mRowSpan, this.mRowSpanMap, flexGridData);
            this.addToSpanMap(flexGridData.mColumnSpan, this.mColumnSpanMap, flexGridData);
        }
        for (int i = 0; i < this.mRows; ++i) {
            for (int j = 0; j < this.mColumns; ++j) {
                if (this.mGrid[i][j] != null) continue;
                this.mGrid[i][j] = new FlexGridData(i, j, i % 2 == 1 ? this.getVerticalGap() : 0, j % 2 == 1 ? this.getHorizontalGap() : 0);
                this.updateRowColumnSizes(this.mGrid[i][j]);
            }
        }
        this.processRowSpanMap();
        this.processColumnSpanMap();
    }

    private void processRowSpanMap() {
        for (ArrayList<FlexGridData> arrayList : this.mRowSpanMap.values()) {
            for (FlexGridData flexGridData : arrayList) {
                int n;
                int n2;
                int n3;
                int n4 = flexGridData.getLastRow();
                int n5 = 0;
                for (n3 = flexGridData.mRow; n3 <= n4; ++n3) {
                    n5 += this.mRowHeights[n3];
                }
                if (n5 >= flexGridData.mSize.height) continue;
                n3 = flexGridData.getNonGapRowSpan();
                n5 = flexGridData.mSize.height - n5;
                while (n5 > 0 && n3 > 0) {
                    n2 = n5 / n3;
                    n3 = 0;
                    for (n = flexGridData.mRow; n <= n4 && n5 > 0; n += 2) {
                        int n6 = this.mRowHeights[n];
                        int n7 = this.mMaxRowHeights[n];
                        if (n6 >= n7) continue;
                        int n8 = n2 <= (n7 -= n6) ? n2 : n7;
                        int n9 = n;
                        this.mRowHeights[n9] = this.mRowHeights[n9] + n8;
                        n5 -= n8;
                        if (n8 == n7) continue;
                        ++n3;
                    }
                }
                n3 = flexGridData.getNonGapRowSpan();
                while (n5 > 0) {
                    n2 = n5 / n3;
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    for (n = flexGridData.mRow; n <= n4 && n5 > 0; n5 -= n2, n += 2) {
                        int n10 = n;
                        this.mRowHeights[n10] = this.mRowHeights[n10] + n2;
                        int n11 = n;
                        this.mMaxRowHeights[n11] = this.mMaxRowHeights[n11] + n2;
                    }
                }
            }
        }
    }

    private void processColumnSpanMap() {
        for (ArrayList<FlexGridData> arrayList : this.mColumnSpanMap.values()) {
            for (FlexGridData flexGridData : arrayList) {
                int n;
                int n2;
                int n3;
                int n4 = flexGridData.getLastColumn();
                int n5 = 0;
                for (n3 = flexGridData.mColumn; n3 <= n4; ++n3) {
                    n5 += this.mColumnWidths[n3];
                }
                if (n5 >= flexGridData.mSize.width) continue;
                n3 = flexGridData.getNonGapColumnSpan();
                n5 = flexGridData.mSize.width - n5;
                while (n5 > 0 && n3 > 0) {
                    n2 = n5 / n3;
                    n3 = 0;
                    for (n = flexGridData.mColumn; n <= n4 && n5 > 0; n += 2) {
                        int n6 = this.mColumnWidths[n];
                        int n7 = this.mMaxColumnWidths[n];
                        if (n6 >= n7) continue;
                        int n8 = n2 <= (n7 -= n6) ? n2 : n7;
                        int n9 = n;
                        this.mColumnWidths[n9] = this.mColumnWidths[n9] + n8;
                        n5 -= n8;
                        if (n8 == n7) continue;
                        ++n3;
                    }
                }
                n3 = flexGridData.getNonGapColumnSpan();
                while (n5 > 0) {
                    n2 = n5 / n3;
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    for (n = flexGridData.mColumn; n <= n4 && n5 > 0; n5 -= n2, n += 2) {
                        int n10 = n;
                        this.mColumnWidths[n10] = this.mColumnWidths[n10] + n2;
                        int n11 = n;
                        this.mMaxColumnWidths[n11] = this.mMaxColumnWidths[n11] + n2;
                    }
                }
            }
        }
    }

    private void addToSpanMap(int n, TreeMap<Integer, ArrayList<FlexGridData>> treeMap, FlexGridData flexGridData) {
        if (n > 1) {
            Integer n2 = new Integer(n);
            ArrayList<FlexGridData> arrayList = treeMap.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                treeMap.put(n2, arrayList);
            }
            arrayList.add(flexGridData);
        }
    }

    private void updateRowColumnSizes(FlexGridData flexGridData) {
        if (flexGridData.mRowSpan == 1) {
            this.updateSizes(flexGridData.mRow, flexGridData.mSize.height, this.mRowHeights, flexGridData.mMinSize.height, this.mMinRowHeights, flexGridData.mMaxSize.height, this.mMaxRowHeights);
        }
        if (flexGridData.mColumnSpan == 1) {
            this.updateSizes(flexGridData.mColumn, flexGridData.mSize.width, this.mColumnWidths, flexGridData.mMinSize.width, this.mMinColumnWidths, flexGridData.mMaxSize.width, this.mMaxColumnWidths);
        }
    }

    private void updateSizes(int n, int n2, int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3) {
        if (n3 > nArray2[n]) {
            nArray2[n] = n3;
        }
        if (n4 < nArray3[n]) {
            nArray3[n] = n4;
        }
        if (n2 > nArray[n]) {
            nArray[n] = n2;
        }
        if (nArray[n] < nArray2[n]) {
            nArray[n] = nArray2[n];
        }
        if (nArray[n] > nArray3[n]) {
            nArray3[n] = nArray[n];
        }
    }
}

