/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import com.trollworks.ttk.layout.FlexCell;
import com.trollworks.ttk.layout.LayoutSize;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;

public class FlexLayout
implements LayoutManager2 {
    private FlexCell mRootCell;

    public FlexLayout() {
    }

    public FlexLayout(FlexCell flexCell) {
        this.mRootCell = flexCell;
    }

    public FlexCell getRootCell() {
        return this.mRootCell;
    }

    public void setRootCell(FlexCell flexCell) {
        this.mRootCell = flexCell;
    }

    @Override
    public void layoutContainer(Container container) {
        if (this.mRootCell != null) {
            Rectangle rectangle = container.getBounds();
            Insets insets = container.getInsets();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            this.mRootCell.layout(rectangle);
        }
    }

    private Dimension getLayoutSize(Container container, LayoutSize layoutSize) {
        Insets insets = container.getInsets();
        Dimension dimension = this.mRootCell != null ? this.mRootCell.getSize(layoutSize) : new Dimension();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, LayoutSize.MINIMUM);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, LayoutSize.PREFERRED);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.getLayoutSize(container, LayoutSize.MAXIMUM);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

