/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class DynamicJMenuItemPropertyChangeListener
implements PropertyChangeListener {
    private static ReferenceQueue<JMenuItem> QUEUE = new ReferenceQueue();
    private WeakReference<JMenuItem> mTarget;
    private Action mAction;
    private PropertyChangeListener mChainedListener;

    DynamicJMenuItemPropertyChangeListener(JMenuItem jMenuItem, Action action, PropertyChangeListener propertyChangeListener) {
        OwnedWeakReference ownedWeakReference;
        while ((ownedWeakReference = (OwnedWeakReference)QUEUE.poll()) != null) {
            DynamicJMenuItemPropertyChangeListener dynamicJMenuItemPropertyChangeListener = (DynamicJMenuItemPropertyChangeListener)ownedWeakReference.getOwner();
            Action action2 = dynamicJMenuItemPropertyChangeListener.mAction;
            if (action2 == null) continue;
            action2.removePropertyChangeListener(dynamicJMenuItemPropertyChangeListener);
        }
        this.mTarget = new OwnedWeakReference(jMenuItem, QUEUE, this);
        this.mAction = action;
        this.mChainedListener = propertyChangeListener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JMenuItem jMenuItem = (JMenuItem)this.mTarget.get();
        if (jMenuItem == null) {
            Action action = (Action)propertyChangeEvent.getSource();
            action.removePropertyChangeListener(this);
        } else if (propertyChangeEvent.getPropertyName().equals("AcceleratorKey")) {
            jMenuItem.setAccelerator((KeyStroke)propertyChangeEvent.getNewValue());
            jMenuItem.invalidate();
            jMenuItem.repaint();
        }
        this.mChainedListener.propertyChange(propertyChangeEvent);
    }

    private class OwnedWeakReference
    extends WeakReference<JMenuItem> {
        private DynamicJMenuItemPropertyChangeListener mOwner;

        OwnedWeakReference(JMenuItem jMenuItem, ReferenceQueue<JMenuItem> referenceQueue, DynamicJMenuItemPropertyChangeListener dynamicJMenuItemPropertyChangeListener2) {
            super(jMenuItem, referenceQueue);
            this.mOwner = dynamicJMenuItemPropertyChangeListener2;
        }

        public Object getOwner() {
            return this.mOwner;
        }
    }
}

