/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu;

import com.trollworks.ttk.menu.Command;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class DynamicMenuEnabler
implements KeyEventDispatcher,
MenuListener {
    private static final HashMap<KeyStroke, Command> MAP = new HashMap();
    private static final DynamicMenuEnabler INSTANCE = new DynamicMenuEnabler();

    private DynamicMenuEnabler() {
    }

    public static void add(Command command) {
        MAP.put(command.getAccelerator(), command);
    }

    public static void remove(Command command) {
        MAP.remove(command.getAccelerator());
    }

    public static void add(JMenu jMenu) {
        jMenu.addMenuListener(INSTANCE);
    }

    public static void remove(JMenu jMenu) {
        jMenu.removeMenuListener(INSTANCE);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Command command = MAP.get(KeyStroke.getKeyStrokeForEvent(keyEvent));
        if (command != null) {
            command.adjustForMenu(null);
        }
        return false;
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        for (Component component : jMenu.getMenuComponents()) {
            JMenuItem jMenuItem;
            Action action;
            if (!(component instanceof JMenuItem) || !((action = (jMenuItem = (JMenuItem)component).getAction()) instanceof Command)) continue;
            ((Command)action).adjustForMenu(jMenuItem);
        }
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(INSTANCE);
    }
}

