/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.edit;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.edit.Duplicatable;
import com.trollworks.ttk.utility.LocalizedMessages;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class DuplicateCommand
extends Command {
    public static final String CMD_DUPLICATE = "Duplicate";
    private static String MSG_TITLE;
    public static final DuplicateCommand INSTANCE;

    private DuplicateCommand() {
        super(MSG_TITLE, CMD_DUPLICATE, 68);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        Duplicatable duplicatable = this.findFocus();
        this.setEnabled(duplicatable != null ? duplicatable.canDuplicateSelection() : false);
    }

    private Duplicatable findFocus() {
        for (Component component = DuplicateCommand.getFocusOwner(); component != null && component.isEnabled(); component = component.getParent()) {
            if (!(component instanceof Duplicatable)) continue;
            return (Duplicatable)((Object)component);
        }
        Window window = DuplicateCommand.getActiveWindow();
        if (window instanceof Duplicatable) {
            return (Duplicatable)((Object)window);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Duplicatable duplicatable = this.findFocus();
        if (duplicatable != null) {
            duplicatable.duplicateSelection();
        }
    }

    static {
        LocalizedMessages.initialize(DuplicateCommand.class);
        INSTANCE = new DuplicateCommand();
    }
}

