/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.file.QuitCommand;
import com.trollworks.ttk.menu.file.SaveCommand;
import com.trollworks.ttk.menu.file.Saveable;
import com.trollworks.ttk.menu.file.SignificantFrame;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.BaseWindow;
import com.trollworks.ttk.widgets.CommitEnforcer;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class CloseCommand
extends Command {
    public static final String CMD_CLOSE = "Close";
    private static String MSG_CLOSE;
    private static String MSG_SAVE;
    private static String MSG_SAVE_CHANGES;
    public static final CloseCommand INSTANCE;

    private CloseCommand() {
        super(MSG_CLOSE, CMD_CLOSE, 87);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.close(CloseCommand.getActiveWindow(), true);
    }

    public boolean close(Window window, boolean bl) {
        if (window != null && !BaseWindow.hasOwnedWindowsShowing(window)) {
            if (window instanceof Saveable) {
                CommitEnforcer.forceFocusToAccept();
                Saveable saveable = (Saveable)((Object)window);
                if (saveable.isModified()) {
                    int n = JOptionPane.showConfirmDialog(window, MessageFormat.format(MSG_SAVE_CHANGES, ((Frame)window).getTitle()), MSG_SAVE, 1);
                    if (n == 2 || n == -1) {
                        return false;
                    }
                    if (n == 0) {
                        SaveCommand.INSTANCE.save(saveable);
                        if (saveable.isModified()) {
                            return false;
                        }
                    }
                }
            }
            window.dispose();
        }
        if (bl) {
            for (Frame frame : Frame.getFrames()) {
                if (!(frame instanceof SignificantFrame) || !frame.isVisible() && !BaseWindow.hasOwnedWindowsShowing(frame)) continue;
                return true;
            }
            QuitCommand.INSTANCE.adjustForMenu(null);
            QuitCommand.INSTANCE.quit();
        }
        return true;
    }

    static {
        LocalizedMessages.initialize(CloseCommand.class);
        INSTANCE = new CloseCommand();
    }
}

