/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.print.PrintManager;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.AppWindow;
import com.trollworks.ttk.widgets.WindowUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import javax.swing.JMenuItem;

public class PageSetupCommand
extends Command {
    public static final String CMD_PAGE_SETUP = "PageSetup";
    private static String MSG_PAGE_SETUP;
    private static String MSG_NO_PRINTER_SELECTED;
    public static final PageSetupCommand INSTANCE;

    private PageSetupCommand() {
        super(MSG_PAGE_SETUP, CMD_PAGE_SETUP, 80, SHIFTED_COMMAND_MODIFIER);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        Window window = PageSetupCommand.getActiveWindow();
        this.setEnabled(window instanceof AppWindow && window instanceof Printable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AppWindow appWindow = (AppWindow)PageSetupCommand.getActiveWindow();
        PrintManager printManager = appWindow.getPrintManager();
        if (printManager != null) {
            printManager.pageSetup(appWindow);
        } else {
            WindowUtils.showError(appWindow, MSG_NO_PRINTER_SELECTED);
        }
    }

    static {
        LocalizedMessages.initialize(PageSetupCommand.class);
        INSTANCE = new PageSetupCommand();
    }
}

