/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.print.PrintManager;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.AppWindow;
import com.trollworks.ttk.widgets.WindowUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import javax.swing.JMenuItem;

public class PrintCommand
extends Command {
    public static final String CMD_PRINT = "Print";
    private static String MSG_PRINT;
    private static String MSG_NO_PRINTER_SELECTED;
    public static final PrintCommand INSTANCE;

    private PrintCommand() {
        super(MSG_PRINT, CMD_PRINT, 80);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        Window window = PrintCommand.getActiveWindow();
        this.setEnabled(window instanceof AppWindow && window instanceof Printable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.print((AppWindow)PrintCommand.getActiveWindow());
    }

    public void print(AppWindow appWindow) {
        if (appWindow instanceof Printable) {
            PrintManager printManager = appWindow.getPrintManager();
            if (printManager != null) {
                printManager.print(appWindow, appWindow.getTitle(), (Printable)((Object)appWindow));
            } else {
                WindowUtils.showError(appWindow, MSG_NO_PRINTER_SELECTED);
            }
        }
    }

    static {
        LocalizedMessages.initialize(PrintCommand.class);
        INSTANCE = new PrintCommand();
    }
}

