/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.file.RecentFilesMenu;
import com.trollworks.ttk.menu.file.SaveAsCommand;
import com.trollworks.ttk.menu.file.Saveable;
import com.trollworks.ttk.utility.LocalizedMessages;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JMenuItem;

public class SaveCommand
extends Command {
    public static final String CMD_SAVE = "Save";
    private static String MSG_SAVE;
    public static final SaveCommand INSTANCE;

    private SaveCommand() {
        super(MSG_SAVE, CMD_SAVE, 83);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        Window window = SaveCommand.getActiveWindow();
        if (window instanceof Saveable) {
            this.setEnabled(((Saveable)((Object)window)).isModified());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.save((Saveable)((Object)SaveCommand.getActiveWindow()));
    }

    public File[] save(Saveable saveable) {
        File file = saveable.getBackingFile();
        if (file != null) {
            File[] fileArray;
            for (File file2 : fileArray = saveable.saveTo(file)) {
                RecentFilesMenu.addRecent(file2);
            }
            return fileArray;
        }
        return SaveAsCommand.INSTANCE.saveAs(saveable);
    }

    static {
        LocalizedMessages.initialize(SaveCommand.class);
        INSTANCE = new SaveCommand();
    }
}

