/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.help;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.utility.App;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.AppWindow;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class AboutCommand
extends Command {
    public static final String CMD_ABOUT = "About";
    private static String MSG_ABOUT;
    public static final AboutCommand INSTANCE;
    static AppWindow ABOUT;

    private AboutCommand() {
        super(MessageFormat.format(MSG_ABOUT, App.getName()), CMD_ABOUT);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (ABOUT != null && ABOUT.isDisplayable() && ABOUT.isVisible()) {
            ABOUT.toFront();
            return;
        }
        JPanel jPanel = App.createAboutPanel();
        if (jPanel != null) {
            ABOUT = new AppWindow(this.getTitle(), null, null);
            ABOUT.add(jPanel);
            ABOUT.setResizable(false);
            ABOUT.pack();
            Dimension dimension = ABOUT.getSize();
            Rectangle rectangle = ABOUT.getGraphicsConfiguration().getBounds();
            ABOUT.setLocation((rectangle.width - dimension.width) / 2, (rectangle.height - dimension.height) / 3);
            GraphicsUtilities.forceOnScreen(ABOUT);
            ABOUT.setVisible(true);
            ABOUT.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    ABOUT = null;
                }
            });
        }
    }

    static {
        LocalizedMessages.initialize(AboutCommand.class);
        INSTANCE = new AboutCommand();
        ABOUT = null;
    }
}

