/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.help;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.widgets.WindowUtils;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JMenuItem;

public class OpenURICommand
extends Command {
    private URI mURI;

    public OpenURICommand(String string, URI uRI) {
        super(string, "OpenURL[" + uRI + "]");
        this.mURI = uRI;
    }

    public OpenURICommand(String string, String string2) {
        super(string, "OpenURL[" + string2 + "]");
        try {
            this.mURI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        jMenuItem.setEnabled(this.mURI != null && Desktop.isDesktopSupported());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mURI != null) {
            try {
                Desktop.getDesktop().browse(this.mURI);
            }
            catch (IOException iOException) {
                WindowUtils.showError(null, iOException.getMessage());
            }
        }
    }
}

