/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.preferences;

import com.trollworks.ttk.layout.Alignment;
import com.trollworks.ttk.layout.FlexComponent;
import com.trollworks.ttk.layout.FlexGrid;
import com.trollworks.ttk.preferences.PreferencePanel;
import com.trollworks.ttk.preferences.PreferencesWindow;
import com.trollworks.ttk.utility.Fonts;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.FontPanel;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.UIManager;

public class FontPreferences
extends PreferencePanel
implements ActionListener {
    private static String MSG_FONTS;
    private FontPanel[] mFontPanels;
    private boolean mIgnore;

    public FontPreferences(PreferencesWindow preferencesWindow) {
        super(MSG_FONTS, preferencesWindow);
        FlexGrid flexGrid = new FlexGrid();
        String[] stringArray = Fonts.getKeys();
        this.mFontPanels = new FontPanel[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            flexGrid.add(new FlexComponent(this.createLabel(Fonts.getDescription(string), null), Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            this.mFontPanels[n] = new FontPanel(UIManager.getFont(string));
            this.mFontPanels[n].setActionCommand(string);
            this.mFontPanels[n].addActionListener(this);
            this.add(this.mFontPanels[n]);
            flexGrid.add(this.mFontPanels[n], n, 1);
            ++n;
        }
        flexGrid.apply(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.mIgnore) {
            Object object = actionEvent.getSource();
            if (object instanceof FontPanel) {
                boolean bl = false;
                for (FontPanel fontPanel : this.mFontPanels) {
                    if (fontPanel != object) continue;
                    Font font = fontPanel.getCurrentFont();
                    if (font.equals(UIManager.getFont(fontPanel.getActionCommand()))) break;
                    UIManager.put(fontPanel.getActionCommand(), font);
                    bl = true;
                    break;
                }
                if (bl) {
                    GraphicsUtilities.forceRepaintAndInvalidate();
                    Fonts.notifyOfFontChanges();
                }
            }
            this.adjustResetButton();
        }
    }

    @Override
    public void reset() {
        Fonts.restoreDefaults();
        this.mIgnore = true;
        for (FontPanel fontPanel : this.mFontPanels) {
            fontPanel.setCurrentFont(UIManager.getFont(fontPanel.getActionCommand()));
        }
        this.mIgnore = false;
        GraphicsUtilities.forceRepaintAndInvalidate();
        Fonts.notifyOfFontChanges();
    }

    @Override
    public boolean isSetToDefaults() {
        return Fonts.isSetToDefaults();
    }

    static {
        LocalizedMessages.initialize(FontPreferences.class);
    }
}

