/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.preferences;

import com.trollworks.ttk.image.ToolkitImage;
import com.trollworks.ttk.preferences.PreferencePanel;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.AppWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreferencesWindow
extends AppWindow
implements ActionListener,
ChangeListener {
    private static String MSG_PREFERENCES;
    private static String MSG_RESET;
    private static final String PREFIX = "PreferencesWindow.";
    private static PreferencesWindow INSTANCE;
    private static final ArrayList<Class<? extends PreferencePanel>> CATEGORIES;
    private JTabbedPane mTabPanel;
    private JButton mResetButton;

    public static void addCategory(Class<? extends PreferencePanel> clazz) {
        CATEGORIES.add(clazz);
    }

    public static void display() {
        if (INSTANCE == null) {
            INSTANCE = new PreferencesWindow();
        }
        INSTANCE.setVisible(true);
    }

    private PreferencesWindow() {
        super(MSG_PREFERENCES, ToolkitImage.getPreferencesIcon(), ToolkitImage.getPreferencesIcon());
        Container container = this.getContentPane();
        this.mTabPanel = new JTabbedPane();
        for (Class<? extends PreferencePanel> clazz : CATEGORIES) {
            try {
                Constructor<? extends PreferencePanel> constructor = clazz.getConstructor(PreferencesWindow.class);
                this.addTab(constructor.newInstance(this));
            }
            catch (Exception exception) {
                System.out.println("Exception trying to load " + clazz);
                exception.printStackTrace();
            }
        }
        this.mTabPanel.addChangeListener(this);
        container.add(this.mTabPanel);
        container.add((Component)this.createResetPanel(), "South");
        this.adjustResetButton();
        this.restoreBounds();
    }

    private void addTab(PreferencePanel preferencePanel) {
        this.mTabPanel.addTab(preferencePanel.toString(), preferencePanel);
    }

    @Override
    public void dispose() {
        INSTANCE = null;
        super.dispose();
    }

    private JPanel createResetPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.mResetButton = new JButton(MSG_RESET);
        this.mResetButton.addActionListener(this);
        jPanel.add(this.mResetButton);
        return jPanel;
    }

    public void adjustResetButton() {
        this.mResetButton.setEnabled(!((PreferencePanel)this.mTabPanel.getSelectedComponent()).isSetToDefaults());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((PreferencePanel)this.mTabPanel.getSelectedComponent()).reset();
        this.adjustResetButton();
    }

    @Override
    public String getWindowPrefsPrefix() {
        return PREFIX;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.adjustResetButton();
    }

    static {
        INSTANCE = null;
        CATEGORIES = new ArrayList();
        LocalizedMessages.initialize(PreferencesWindow.class);
    }
}

