/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.print;

import com.trollworks.ttk.utility.LocalizedMessages;
import javax.print.attribute.standard.Sides;

public enum PageSides {
    SINGLE{

        @Override
        public Sides getSides() {
            return Sides.ONE_SIDED;
        }

        public String toString() {
            return MSG_SINGLE;
        }
    }
    ,
    DUPLEX{

        @Override
        public Sides getSides() {
            return Sides.DUPLEX;
        }

        public String toString() {
            return MSG_DUPLEX;
        }
    }
    ,
    TUMBLE{

        @Override
        public Sides getSides() {
            return Sides.TUMBLE;
        }

        public String toString() {
            return MSG_TUMBLE;
        }
    };

    static String MSG_SINGLE;
    static String MSG_DUPLEX;
    static String MSG_TUMBLE;

    public abstract Sides getSides();

    public static final PageSides get(Sides sides) {
        for (PageSides pageSides : PageSides.values()) {
            if (pageSides.getSides() != sides) continue;
            return pageSides;
        }
        return SINGLE;
    }

    static {
        LocalizedMessages.initialize(PageSides.class);
    }
}

