/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import com.trollworks.ttk.text.Numbers;
import java.text.ParseException;
import javax.swing.JFormattedTextField;

public class IntegerFormatter
extends JFormattedTextField.AbstractFormatter {
    private int mMinValue;
    private int mMaxValue;
    private boolean mForceSign;

    public IntegerFormatter(boolean bl) {
        this.mMinValue = Integer.MIN_VALUE;
        this.mMaxValue = Integer.MAX_VALUE;
        this.mForceSign = bl;
    }

    public IntegerFormatter(int n, int n2, boolean bl) {
        this.mMinValue = n;
        this.mMaxValue = n2;
        this.mForceSign = bl;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        return new Integer(Math.min(Math.max(Numbers.getLocalizedInteger(string, this.mMinValue <= 0 && this.mMaxValue >= 0 ? 0 : this.mMinValue), this.mMinValue), this.mMaxValue));
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        int n = (Integer)object;
        return this.mForceSign ? Numbers.formatWithForcedSign(n) : Numbers.format(n);
    }
}

