/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import java.text.NumberFormat;
import java.util.Comparator;

public class NumericStringComparator
implements Comparator<String> {
    public static final NumericStringComparator CASELESS_COMPARATOR = new NumericStringComparator(true);
    public static final NumericStringComparator COMPARATOR = new NumericStringComparator(false);
    private static NumberFormat DECIMAL_FORMATTER = null;
    private boolean mCaseless;

    private NumericStringComparator(boolean bl) {
        this.mCaseless = bl;
    }

    public static int caselessCompareStrings(String string, String string2) {
        return CASELESS_COMPARATOR.compare(string, string2);
    }

    public static int compareStrings(String string, String string2) {
        return COMPARATOR.compare(string, string2);
    }

    private static final NumberFormat getDecimalFormatter() {
        if (DECIMAL_FORMATTER == null) {
            DECIMAL_FORMATTER = NumberFormat.getInstance();
            DECIMAL_FORMATTER.setMinimumFractionDigits(16);
            DECIMAL_FORMATTER.setMaximumFractionDigits(16);
        }
        return DECIMAL_FORMATTER;
    }

    private static final boolean isNumericPortion(char c) {
        return c == '-' || c == '.' || c == ',' || c >= '0' && c <= '9';
    }

    @Override
    public int compare(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        NumberFormat numberFormat = NumericStringComparator.getDecimalFormatter();
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        int n4 = cArray2.length;
        int n5 = 0;
        int n6 = 0;
        while (n5 == 0 && n < n3 && n2 < n4) {
            char c;
            char c2;
            boolean bl = true;
            char c3 = cArray[n++];
            char c4 = cArray2[n2++];
            if (NumericStringComparator.isNumericPortion(c3) && NumericStringComparator.isNumericPortion(c4)) {
                c2 = '\u0000';
                c = '\u0000';
                int n7 = 1;
                int n8 = 1;
                if (c3 >= '0' && c3 <= '9') {
                    c2 = '\u0001';
                }
                while (n < n3 && NumericStringComparator.isNumericPortion(c3 = cArray[n])) {
                    if (c2 == '\u0000' && c3 >= '0' && c3 <= '9') {
                        c2 = '\u0001';
                    }
                    ++n7;
                    ++n;
                }
                if (c4 >= '0' && c4 <= '9') {
                    c = '\u0001';
                }
                while (n2 < n4 && NumericStringComparator.isNumericPortion(c4 = cArray2[n2])) {
                    if (c == '\u0000' && c4 >= '0' && c4 <= '9') {
                        c = '\u0001';
                    }
                    ++n8;
                    ++n2;
                }
                if (c2 != '\u0000' && c != '\u0000') {
                    try {
                        double d = numberFormat.parse(string.substring(n - n7, n)).doubleValue();
                        double d2 = numberFormat.parse(string2.substring(n2 - n8, n2)).doubleValue();
                        bl = false;
                        n5 = d > d2 ? 1 : (d < d2 ? -1 : 0);
                        if (n5 == 0 && n6 == 0) {
                            n6 = n7 - n8;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl) {
                    n -= n7;
                    n2 -= n8;
                    c3 = cArray[n++];
                    c4 = cArray2[n2++];
                }
            }
            if (!bl) continue;
            if (this.mCaseless) {
                c2 = Character.isLowerCase(c3) ? Character.toUpperCase(c3) : c3;
                c = Character.isLowerCase(c4) ? Character.toUpperCase(c4) : c4;
                n5 = c2 - c;
                continue;
            }
            n5 = c3 - c4;
        }
        if (n5 == 0) {
            n5 = n3 - n - (n4 - n2);
        }
        if (n5 == 0) {
            n5 = n6;
        }
        if (n5 < 0) {
            n5 = -1;
        } else if (n5 > 0) {
            n5 = 1;
        }
        return n5;
    }
}

