/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class TextUtility {
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final char ELLIPSIS = '\u2026';

    public static final String truncateIfNecessary(String string, int n, int n2) {
        int n3 = string.length();
        n = n3 - n;
        if (n > 0) {
            ++n;
            if (n2 == 2) {
                return '\u2026' + string.substring(n);
            }
            if (n2 == 0) {
                int n4 = n3 - n;
                int n5 = n4 / 2;
                int n6 = n4 - n5;
                StringBuilder stringBuilder = new StringBuilder(n4 + 1);
                if (n5 > 0) {
                    stringBuilder.append(string.substring(0, n5));
                }
                stringBuilder.append('\u2026');
                if (n6 > 0) {
                    stringBuilder.append(string.substring(n3 - n6));
                }
                return stringBuilder.toString();
            }
            return string.substring(0, n3 - n) + '\u2026';
        }
        return string;
    }

    public static final String standardizeLineEndings(String string) {
        return TextUtility.standardizeLineEndings(string, NEWLINE);
    }

    public static final String standardizeLineEndings(String string, String string2) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            if (n3 == n2) {
                n2 = 0;
                continue;
            }
            if (n3 == 13) {
                n2 = 10;
                stringBuilder.append(string2);
                continue;
            }
            if (n3 == 10) {
                n2 = 13;
                stringBuilder.append(string2);
                continue;
            }
            n2 = 0;
            stringBuilder.append((char)n3);
        }
        return stringBuilder.toString();
    }

    public static final ArrayList<String> extractLines(String string, int n) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = string.charAt(i);
            if (n5 == n3) {
                n3 = 0;
                continue;
            }
            if (n5 == 13) {
                n3 = 10;
                n4 = 0;
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            if (n5 == 10) {
                n3 = 13;
                n4 = 0;
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            if (n5 == 9 && n > 0) {
                int n6 = n - n4 % n;
                n3 = 0;
                while (--n6 >= 0) {
                    stringBuilder.append(' ');
                    ++n4;
                }
                continue;
            }
            n3 = 0;
            ++n4;
            stringBuilder.append((char)n5);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static String makeFiller(int n, char c) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String makeNote(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length() * 2);
        String string3 = TextUtility.makeFiller(string.length() + 1, ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string2, NEWLINE);
        if (stringTokenizer.hasMoreTokens()) {
            stringBuilder.append(string);
            stringBuilder.append(SPACE);
            stringBuilder.append(stringTokenizer.nextToken());
            stringBuilder.append(NEWLINE);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append(string3);
                stringBuilder.append(stringTokenizer.nextToken());
                stringBuilder.append(NEWLINE);
            }
        }
        return stringBuilder.toString();
    }

    public static String wrapToCharacterCount(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        StringBuilder stringBuilder2 = new StringBuilder(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string + NEWLINE, NEWLINE, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(NEWLINE)) {
                stringBuilder.append(string2);
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t", true);
            int n2 = 0;
            stringBuilder2.setLength(0);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                int n3 = string3.length();
                if (n2 == 0 && string3.equals(SPACE)) continue;
                if (n2 == 0 || n2 + n3 <= n) {
                    stringBuilder2.append(string3);
                    n2 += n3;
                    continue;
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append(NEWLINE);
                stringBuilder2.setLength(0);
                if (!string3.equals(SPACE)) {
                    stringBuilder2.append(string3);
                    n2 = n3;
                    continue;
                }
                n2 = 0;
            }
            if (n2 <= 0) continue;
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }
}

