/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import com.trollworks.ttk.text.Numbers;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLGenerator {
    private static final String ENCODING = "US-ASCII";
    private String mIndent = "\t";
    private XMLStreamWriter mWriter;
    private int mDepth;
    private boolean mHadText;

    public XMLGenerator(OutputStream outputStream) throws XMLStreamException {
        this.mWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, ENCODING);
    }

    public void setIndent(String string) {
        this.mIndent = string;
    }

    public void startDocument() throws XMLStreamException {
        this.mWriter.writeStartDocument(ENCODING, "1.0");
    }

    public void endDocument() throws XMLStreamException {
        this.mWriter.writeEndDocument();
    }

    private void eol() throws XMLStreamException {
        this.mWriter.writeCharacters("\n");
        for (int i = 0; i < this.mDepth; ++i) {
            this.mWriter.writeCharacters(this.mIndent);
        }
    }

    public void startTag(String string) throws XMLStreamException {
        this.eol();
        this.mWriter.writeStartElement(string);
        ++this.mDepth;
    }

    public void startEmptyTag(String string) throws XMLStreamException {
        this.eol();
        this.mWriter.writeEmptyElement(string);
    }

    public void endTag() throws XMLStreamException {
        --this.mDepth;
        if (!this.mHadText) {
            this.eol();
        } else {
            this.mHadText = false;
        }
        this.mWriter.writeEndElement();
    }

    public void addAttribute(String string, String string2) throws XMLStreamException {
        this.mWriter.writeAttribute(string, string2 == null ? "" : string2);
    }

    public void addAttribute(String string, boolean bl) throws XMLStreamException {
        this.mWriter.writeAttribute(string, bl ? "yes" : "no");
    }

    public void addAttribute(String string, short s) throws XMLStreamException {
        this.mWriter.writeAttribute(string, Short.toString(s));
    }

    public void addAttribute(String string, int n) throws XMLStreamException {
        this.mWriter.writeAttribute(string, Integer.toString(n));
    }

    public void addAttribute(String string, long l) throws XMLStreamException {
        this.mWriter.writeAttribute(string, Long.toString(l));
    }

    public void addAttribute(String string, float f) throws XMLStreamException {
        this.mWriter.writeAttribute(string, Numbers.trimTrailingZerosAfterDecimal(Float.toString(f)));
    }

    public void addAttribute(String string, double d) throws XMLStreamException {
        this.mWriter.writeAttribute(string, Numbers.trimTrailingZerosAfterDecimal(Double.toString(d)));
    }

    public void addAttributeNotEmpty(String string, String string2) throws XMLStreamException {
        if (string2 != null && string2.length() > 0) {
            this.mWriter.writeAttribute(string, string2);
        }
    }

    public void addAttributeNot(String string, String string2, String string3) throws XMLStreamException {
        if (string3 != null ? !string3.equals(string2) : string2 != null) {
            this.addAttribute(string, string2);
        }
    }

    public void addAttributeNot(String string, boolean bl, boolean bl2) throws XMLStreamException {
        if (bl != bl2) {
            this.addAttribute(string, bl);
        }
    }

    public void addAttributeNot(String string, short s, short s2) throws XMLStreamException {
        if (s != s2) {
            this.addAttribute(string, s);
        }
    }

    public void addAttributeNot(String string, int n, int n2) throws XMLStreamException {
        if (n != n2) {
            this.addAttribute(string, n);
        }
    }

    public void addAttributeNot(String string, long l, long l2) throws XMLStreamException {
        if (l != l2) {
            this.addAttribute(string, l);
        }
    }

    public void addAttributeNot(String string, float f, float f2) throws XMLStreamException {
        if (f != f2) {
            this.addAttribute(string, f);
        }
    }

    public void addAttributeNot(String string, double d, double d2) throws XMLStreamException {
        if (d != d2) {
            this.addAttribute(string, d);
        }
    }

    public void addText(String string) throws XMLStreamException {
        this.mWriter.writeCharacters(string);
        this.mHadText = true;
    }

    public void comment(String string) throws XMLStreamException {
        this.eol();
        this.mWriter.writeComment(' ' + string + ' ');
    }

    public void close() throws XMLStreamException {
        this.mWriter.close();
        this.mWriter = null;
    }
}

