/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.units;

import com.trollworks.ttk.units.Units;

public class UnitsValue<T extends Units>
implements Cloneable,
Comparable<UnitsValue<T>> {
    private double mValue;
    private T mUnits;

    public UnitsValue(double d, T t) {
        this.mValue = d;
        this.mUnits = t;
    }

    public void set(UnitsValue<T> unitsValue) {
        this.mValue = unitsValue.mValue;
        this.mUnits = unitsValue.mUnits;
    }

    public T getUnits() {
        return this.mUnits;
    }

    public void setUnits(T t) {
        this.mUnits = t;
    }

    public double getValue() {
        return this.mValue;
    }

    public void setValue(double d) {
        this.mValue = d;
    }

    public double getNormalizedValue() {
        return this.mUnits.normalize(this.mValue);
    }

    public void add(UnitsValue<?> unitsValue) {
        this.mValue += this.mUnits.convert((Units)unitsValue.mUnits, unitsValue.mValue);
    }

    public void subtract(UnitsValue<?> unitsValue) {
        this.mValue -= this.mUnits.convert((Units)unitsValue.mUnits, unitsValue.mValue);
    }

    public T getDefaultUnits() {
        return null;
    }

    @Override
    public int compareTo(UnitsValue<T> unitsValue) {
        if (this == unitsValue) {
            return 0;
        }
        double d = this.getNormalizedValue() - unitsValue.getNormalizedValue();
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        return this.mUnits.format(this.mValue, bl);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UnitsValue) {
            UnitsValue unitsValue = (UnitsValue)object;
            return this.mUnits == unitsValue.mUnits && this.mValue == unitsValue.mValue;
        }
        return false;
    }

    public UnitsValue<T> clone() {
        try {
            return (UnitsValue)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

