/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.units;

import com.trollworks.ttk.text.Numbers;
import com.trollworks.ttk.units.UnitsValue;
import com.trollworks.ttk.units.WeightUnits;

public class WeightValue
extends UnitsValue<WeightUnits> {
    public static WeightValue extract(String string) {
        WeightUnits weightUnits = WeightUnits.POUNDS;
        if (string != null) {
            string = string.trim();
            for (WeightUnits weightUnits2 : WeightUnits.values()) {
                String string2 = weightUnits2.toString();
                if (!string.endsWith(string2)) continue;
                weightUnits = weightUnits2;
                string = string.substring(0, string.length() - string2.length());
                break;
            }
        }
        return new WeightValue(Numbers.getDouble(string, 0.0), weightUnits);
    }

    public WeightValue(double d, WeightUnits weightUnits) {
        super(d, weightUnits);
    }

    @Override
    public WeightUnits getDefaultUnits() {
        return WeightUnits.POUNDS;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof WeightValue && super.equals(object);
    }

    @Override
    public WeightValue clone() {
        return (WeightValue)super.clone();
    }
}

