/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;

public class LocalizedMessages
extends Properties
implements PrivilegedAction<Object> {
    private static final String PREFIX = "MSG_";
    private static final String IN = "\" in: ";
    private static final String EXTENSION = ".properties";
    private static final int MOD_EXPECTED = 8;
    private static final int MOD_MASK = 24;
    private static final String[] SUFFIXES;
    private Class<?> mClass;
    private HashSet<Field> mInitialized = new HashSet();
    private HashMap<String, Field> mFields = new HashMap();
    private String mBundleName;
    private boolean mIsAccessible;

    public static void initialize(Class<?> clazz) {
        LocalizedMessages localizedMessages = new LocalizedMessages(clazz);
        if (System.getSecurityManager() == null) {
            localizedMessages.run();
        } else {
            AccessController.doPrivileged(localizedMessages);
        }
    }

    private LocalizedMessages(Class<?> clazz) {
        this.mClass = clazz;
        this.mBundleName = clazz.getName();
        this.mIsAccessible = (this.mClass.getModifiers() & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run() {
        int n;
        Field[] fieldArray = this.mClass.getDeclaredFields();
        ClassLoader classLoader = this.mClass.getClassLoader();
        String string = this.mBundleName.replace('.', '/');
        String[] stringArray = new String[SUFFIXES.length];
        int n2 = fieldArray.length;
        for (n = 0; n < n2; ++n) {
            this.mFields.put(fieldArray[n].getName(), fieldArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = string + SUFFIXES[n];
        }
        for (String string2 : stringArray) {
            InputStream inputStream;
            InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
            if (inputStream == null) continue;
            try {
                this.load(inputStream);
            }
            catch (IOException iOException) {
                System.err.println("Error: Unable to load " + string2);
                iOException.printStackTrace(System.err);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                this.clear();
            }
        }
        for (int i = 0; i < n2; ++i) {
            Field field = fieldArray[i];
            if (!field.getName().startsWith(PREFIX) || (field.getModifiers() & 0x18) != 8 || this.mInitialized.contains(field)) continue;
            try {
                String string3 = "Warning: Missing message for \"" + field.getName() + IN + this.mBundleName;
                System.err.println(string3);
                if (!this.mIsAccessible || (field.getModifiers() & 1) == 0) {
                    field.setAccessible(true);
                }
                field.set(null, string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public synchronized Object put(Object object, Object object2) {
        Field field = this.mFields.get(PREFIX + object);
        if (field == null) {
            System.err.println("Warning: Unused message for \"" + object + IN + this.mBundleName);
            return null;
        }
        if (!this.mInitialized.contains(field)) {
            int n = field.getModifiers();
            this.mInitialized.add(field);
            if ((n & 0x18) != 8) {
                System.err.println("Warning: Incorrect field modifiers for \"" + field.getName() + IN + this.mBundleName);
                return null;
            }
            try {
                if (!this.mIsAccessible || (n & 1) == 0) {
                    field.setAccessible(true);
                }
                field.set(null, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        String string = Locale.getDefault().toString();
        ArrayList<String> arrayList = new ArrayList<String>(4);
        while (true) {
            arrayList.add('_' + string + EXTENSION);
            int n = string.lastIndexOf(95);
            if (n == -1) break;
            string = string.substring(0, n);
        }
        arrayList.add(EXTENSION);
        SUFFIXES = arrayList.toArray(new String[arrayList.size()]);
    }
}

