/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import java.io.File;
import java.util.StringTokenizer;

public class Path {
    public static final String enforceExtension(String string, String string2) {
        return Path.enforceExtension(string, string2, false);
    }

    public static final String enforceExtension(String string, String string2, boolean bl) {
        string = string.replace('\\', '/');
        if (string2.charAt(0) != '.') {
            string2 = '.' + string2;
        }
        if (!string.endsWith(string2)) {
            int n = string.lastIndexOf(46);
            if (string.lastIndexOf(47) > n) {
                n = -1;
            }
            if (n == -1) {
                return string + string2;
            }
            if (n == string.length() - 1) {
                return string + string2.substring(1);
            }
            if (!bl) {
                return string.substring(0, n) + string2;
            }
        }
        return string;
    }

    public static final String getCommonRoot(String string, String string2) {
        int n;
        int n2;
        int n3;
        if (string == null) {
            n3 = 0;
        } else {
            string = string.replace('\\', '/');
            n3 = string.length();
        }
        if (string2 == null) {
            n2 = 0;
        } else {
            string2 = string2.replace('\\', '/');
            n2 = string2.length();
        }
        int n4 = n3 > n2 ? n2 : n3;
        for (n = 0; n < n4; ++n) {
            if (string.charAt(n) == string2.charAt(n)) continue;
            --n;
            break;
        }
        if (n == n4) {
            n = n4 - 1;
        }
        while (n >= 0 && string.charAt(n) != '/') {
            --n;
        }
        if (n < 0) {
            return null;
        }
        return string.substring(0, n + 1);
    }

    public static final String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = (string = string.replace('\\', '/')).lastIndexOf(46);
        if (n == -1 || n == string.length() - 1 || n < string.lastIndexOf(47)) {
            return "";
        }
        return string.substring(n);
    }

    public static final File getFile(String string) {
        return new File(Path.getPathForPlatform(string));
    }

    public static final File getFile(String string, String string2) {
        return new File(Path.getPathForPlatform(Path.getFullPath(string, string2)));
    }

    public static final String getFullPath(String string, String string2) {
        String string3;
        if (string2 != null) {
            if (string != null) {
                string = string.replace('\\', '/');
                string3 = Path.isFullPath(string2 = string2.replace('\\', '/')) ? string2 : (string.endsWith("/") ? string + string2 : string + "/" + string2);
            } else {
                string3 = string2.replace('\\', '/');
            }
        } else {
            string3 = string != null ? string : "./";
        }
        if (string3.startsWith("./") || string3.startsWith("../")) {
            return Path.getFullPath(Path.getFullPath(new File(".")), string3);
        }
        return Path.normalizeFullPath(string3);
    }

    public static final String getFullPath(File file) {
        if (file != null) {
            return Path.normalizeFullPath(file.getAbsolutePath().replace('\\', '/'));
        }
        return null;
    }

    public static final String getLeafName(String string) {
        return Path.getLeafName(string, true);
    }

    public static final String getLeafName(String string, boolean bl) {
        if (string != null) {
            int n = (string = string.replace('\\', '/')).lastIndexOf(47);
            if (n != -1) {
                if (n == string.length() - 1) {
                    return "";
                }
                string = string.substring(n + 1);
            }
            if (!bl && (n = string.lastIndexOf(46)) != -1) {
                string = string.substring(0, n);
            }
            return string;
        }
        return null;
    }

    public static final String getParent(String string) {
        return Path.getParent(string, true);
    }

    public static final String getParent(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = (string = string.replace('\\', '/')).lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n + (bl ? 1 : 0));
    }

    public static final String getPathForPlatform(String string) {
        return string.replace('\\', '/').replace('/', File.separatorChar);
    }

    public static final String getRelativePath(String string, String string2) {
        String string3;
        if (string != null) {
            string = string.replace('\\', '/');
        }
        if (string2 != null) {
            string2 = string2.replace('\\', '/');
        }
        if ((string3 = Path.getCommonRoot(string, string2)) != null) {
            if (string3.equals(string)) {
                return string2.substring(string3.length());
            }
            StringBuilder stringBuilder = new StringBuilder(string2.length());
            String string4 = string.substring(string3.length());
            int n = string4.indexOf(47);
            while (n != -1) {
                stringBuilder.append("../");
                n = string4.indexOf(47, n + 1);
            }
            stringBuilder.append(string2.substring(string3.length()));
            return stringBuilder.toString();
        }
        return string2;
    }

    public static final String getRelativePath(String string, File file) {
        return Path.getRelativePath(string, Path.getFullPath(file));
    }

    public static final boolean isFullPath(String string) {
        char c;
        int n;
        boolean bl = false;
        if (string != null && (n = string.length()) > 0 && ((c = (string = string.replace('\\', '/')).charAt(0)) == '/' || string.startsWith("//") || n > 1 && string.charAt(1) == ':' && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z'))) {
            bl = true;
        }
        return bl;
    }

    public static final String normalizeFullPath(String string) {
        if (string != null) {
            char c;
            StringBuilder stringBuilder;
            int n;
            string = string.replace('\\', '/');
            do {
                if ((n = string.indexOf("/./")) == -1) continue;
                stringBuilder = new StringBuilder(string);
                stringBuilder.delete(n, n + 2);
                string = stringBuilder.toString();
            } while (n != -1);
            do {
                if ((n = string.indexOf("/../")) == -1) continue;
                int n2 = 3;
                stringBuilder = new StringBuilder(string);
                while (n > 0) {
                    c = stringBuilder.charAt(--n);
                    ++n2;
                    if (c == '/') break;
                    if (c != ':') continue;
                    ++n;
                    --n2;
                    break;
                }
                stringBuilder.delete(n, n + n2);
                string = stringBuilder.toString();
            } while (n != -1);
            if (string.endsWith("/.")) {
                string = string.substring(0, string.length() - 2);
            }
            if (string.endsWith("/..")) {
                n = string.length() - 3;
                while (n > 0 && (c = string.charAt(--n)) != '/' && c != ':') {
                }
                string = string.substring(0, n);
            }
            if (string.length() > 1 && string.charAt(1) == ':') {
                string = Character.toUpperCase(string.charAt(0)) + ":" + string.substring(2);
            }
        }
        return string;
    }

    public static File isCommandPathViable(String string, File file) {
        if (string != null) {
            File file2 = new File(string);
            if (file2.isFile()) {
                return file2;
            }
            if (string.indexOf(File.separatorChar) == -1) {
                if (file != null && (file2 = new File(file, string)).isFile()) {
                    return file2;
                }
                String string2 = System.getenv("PATH");
                if (string2 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
                    while (stringTokenizer.hasMoreTokens()) {
                        file2 = new File(stringTokenizer.nextToken(), string);
                        if (!file2.isFile()) continue;
                        return file2;
                    }
                }
            }
        }
        return null;
    }
}

