/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.utility.SelectionOwner;
import java.util.BitSet;

public class Selection {
    public static final int MOUSE_NONE = 0;
    public static final int MOUSE_EXTEND = 1;
    public static final int MOUSE_FLIP = 2;
    private BitSet mSelection;
    private int mSize;
    private int mAnchor;
    private SelectionOwner mOwner;

    public Selection(SelectionOwner selectionOwner) {
        this.mOwner = selectionOwner;
        this.mSelection = new BitSet();
        this.mAnchor = -1;
    }

    public Selection(SelectionOwner selectionOwner, int n) {
        this(selectionOwner);
        this.mSize = n;
    }

    public Selection(Selection selection) {
        this.mOwner = selection.mOwner;
        this.mSelection = (BitSet)selection.mSelection.clone();
        this.mSize = selection.mSize;
        this.mAnchor = selection.mAnchor;
    }

    public int getAnchor() {
        return this.mAnchor;
    }

    public void setAnchor(int n) {
        this.mAnchor = n < 0 || n >= this.mSize ? -1 : n;
    }

    public void setSize(int n) {
        int n2 = this.mSelection.length();
        if (n < 0) {
            n = 0;
        }
        if (n2 >= n) {
            this.mSelection.clear(n, n2);
        }
        this.mSize = n;
        if (this.mAnchor >= this.mSize) {
            this.mAnchor = this.firstSelectedIndex();
        }
    }

    public boolean isSelected(int n) {
        if (n < 0 || n >= this.mSize) {
            return false;
        }
        return this.mSelection.get(n);
    }

    public boolean isEmpty() {
        return this.lastSelectedIndex() == -1;
    }

    public int getCount() {
        if (this.mSelection.length() > this.mSize) {
            this.mSelection = this.mSelection.get(0, this.mSize);
        }
        return this.mSelection.cardinality();
    }

    public int firstSelectedIndex() {
        return this.nextSelectedIndex(0);
    }

    public int nextSelectedIndex(int n) {
        int n2 = this.mSelection.nextSetBit(n);
        return n2 < this.mSize ? n2 : -1;
    }

    public int lastSelectedIndex() {
        int n = this.mSelection.length() - 1;
        return n < this.mSize ? n : -1;
    }

    public int[] getSelectedIndexes() {
        int[] nArray = new int[this.getCount()];
        int n = 0;
        int n2 = this.firstSelectedIndex();
        while (n2 != -1) {
            nArray[n++] = n2;
            n2 = this.nextSelectedIndex(n2 + 1);
        }
        return nArray;
    }

    public boolean canSelectAll() {
        return this.mSize != this.getCount();
    }

    public void select() {
        if (this.mSize > 0 && this.canSelectAll()) {
            this.selectionAboutToChange();
            this.mSelection.set(0, this.mSize);
            this.mAnchor = 0;
            this.selectionDidChange();
        }
    }

    public void select(int n, boolean bl) {
        int n2;
        BitSet bitSet = (BitSet)this.mSelection.clone();
        if (!bl) {
            bitSet.clear();
        }
        int n3 = n2 = (n2 = bitSet.length() - 1) < this.mSize ? n2 : -1;
        if (n2 == -1) {
            int n4 = this.mAnchor = n < 0 || n >= this.mSize ? -1 : n;
        }
        if (n >= 0 && n < this.mSize) {
            bitSet.set(n);
        }
        this.applySelectionChange(bitSet);
    }

    public void select(int n, int n2, boolean bl) {
        int n3;
        BitSet bitSet = (BitSet)this.mSelection.clone();
        if (!bl) {
            bitSet.clear();
        }
        int n4 = n3 = (n3 = bitSet.length() - 1) < this.mSize ? n3 : -1;
        if (n3 == -1) {
            int n5 = this.mAnchor = n < 0 || n >= this.mSize ? -1 : n;
        }
        if (n > n2) {
            int n6 = n;
            n = n2;
            n2 = n6;
        }
        if (n < this.mSize) {
            if (n2 >= this.mSize) {
                n2 = this.mSize - 1;
            }
            bitSet.set(n, n2 + 1);
        }
        this.applySelectionChange(bitSet);
    }

    public void select(int[] nArray, boolean bl) {
        int n;
        BitSet bitSet = (BitSet)this.mSelection.clone();
        if (!bl) {
            bitSet.clear();
        }
        int n2 = n = (n = bitSet.length() - 1) < this.mSize ? n : -1;
        if (n == -1) {
            this.mAnchor = nArray.length > 0 ? ((n = nArray[0]) < 0 || n >= this.mSize ? -1 : n) : -1;
        }
        for (int n3 : nArray) {
            n = n3;
            if (n <= -1 || n >= this.mSize) continue;
            bitSet.set(n);
        }
        this.applySelectionChange(bitSet);
    }

    public int selectUp(boolean bl) {
        int n = -1;
        if (this.mSize > 0) {
            int n2 = this.getCount();
            if (bl && n2 > 0) {
                n = this.lastSelectedIndex();
                if (n > this.mAnchor) {
                    this.deselect(n--);
                } else {
                    n = this.firstSelectedIndex() - 1;
                    if (n >= 0) {
                        this.select(n, true);
                    }
                }
            } else if (n2 == 0) {
                this.select(this.mSize - 1, false);
            } else {
                n = this.firstSelectedIndex();
                if (n2 == 1) {
                    --n;
                }
                if (n >= 0) {
                    this.select(n, false);
                }
            }
        }
        return n < 0 || n >= this.mSize ? -1 : n;
    }

    public int selectDown(boolean bl) {
        int n = -1;
        if (this.mSize > 0) {
            int n2 = this.getCount();
            if (bl && n2 > 0) {
                n = this.firstSelectedIndex();
                if (n < this.mAnchor) {
                    this.deselect(n++);
                } else {
                    n = this.lastSelectedIndex() + 1;
                    if (n < this.mSize) {
                        this.select(n, true);
                    }
                }
            } else if (n2 == 0) {
                this.select(0, false);
            } else {
                n = this.lastSelectedIndex();
                if (n2 == 1) {
                    ++n;
                }
                if (n < this.mSize) {
                    this.select(n, false);
                }
            }
        }
        return n < 0 || n >= this.mSize ? -1 : n;
    }

    public int selectToHome(boolean bl) {
        if (this.mSize > 0) {
            if (bl && !this.isEmpty()) {
                if (this.mAnchor < 0) {
                    this.mAnchor = this.lastSelectedIndex();
                }
                this.select(0, this.mAnchor, true);
            } else {
                this.select(0, false);
            }
            return 0;
        }
        return -1;
    }

    public int selectToEnd(boolean bl) {
        if (this.mSize > 0) {
            if (bl && !this.isEmpty()) {
                if (this.mAnchor < 0) {
                    this.mAnchor = this.firstSelectedIndex();
                }
                this.select(this.mAnchor, this.mSize - 1, true);
            } else {
                this.select(this.mSize - 1, false);
            }
            return this.mSize - 1;
        }
        return -1;
    }

    public int selectByMouse(int n, int n2) {
        if (n != -1) {
            if (this.mAnchor >= 0 && (n2 & 1) == 1) {
                this.select(this.mAnchor, n, true);
            } else if ((n2 & 2) == 2) {
                if (this.isSelected(n)) {
                    this.deselect(n);
                } else {
                    this.select(n, true);
                }
            } else if (!this.isSelected(n)) {
                this.select(n, false);
            } else if (this.getCount() != 1) {
                return n;
            }
        } else {
            this.deselect();
        }
        return -1;
    }

    public void deselect() {
        if (!this.isEmpty()) {
            this.selectionAboutToChange();
            this.mSelection.clear();
            this.mAnchor = -1;
            this.selectionDidChange();
        }
    }

    public void deselect(int n) {
        if (this.mSelection.get(n)) {
            this.selectionAboutToChange();
            this.mSelection.clear(n);
            if (this.mAnchor == n) {
                this.mAnchor = this.firstSelectedIndex();
            }
            this.selectionDidChange();
        }
    }

    public void deselect(int n, int n2) {
        int n3;
        BitSet bitSet = (BitSet)this.mSelection.clone();
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        bitSet.clear(n, n2 + 1);
        if (this.mAnchor >= n && this.mAnchor <= n2) {
            n3 = bitSet.nextSetBit(0);
            this.mAnchor = n3 < this.mSize ? n3 : -1;
        }
        this.applySelectionChange(bitSet);
    }

    public void deselect(int[] nArray) {
        BitSet bitSet = (BitSet)this.mSelection.clone();
        for (int n : nArray) {
            bitSet.clear(n);
            if (this.mAnchor != n) continue;
            this.mAnchor = -1;
        }
        if (this.mAnchor == -1) {
            int n = bitSet.nextSetBit(0);
            this.mAnchor = n < this.mSize ? n : -1;
        }
        this.applySelectionChange(bitSet);
    }

    private void applySelectionChange(BitSet bitSet) {
        if (!bitSet.equals(this.mSelection)) {
            this.selectionAboutToChange();
            this.mSelection = bitSet;
            this.selectionDidChange();
        }
    }

    private void selectionDidChange() {
        if (this.mOwner != null) {
            this.mOwner.selectionDidChange();
        }
    }

    private void selectionAboutToChange() {
        if (this.mOwner != null) {
            this.mOwner.selectionAboutToChange();
        }
    }
}

