/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.utility.GraphicsUtilities;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class WindowSizeEnforcer
implements ComponentListener {
    public WindowSizeEnforcer(Window window) {
        window.addComponentListener(this);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        WindowSizeEnforcer.enforce((Window)componentEvent.getSource());
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        GraphicsUtilities.forceOnScreen((Window)componentEvent.getComponent());
    }

    public static void enforce(Window window) {
        Dimension dimension = window.getSize();
        Dimension dimension2 = window.getMinimumSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n < dimension2.width) {
            n = dimension2.width;
        }
        if (n2 < dimension2.height) {
            n2 = dimension2.height;
        }
        dimension2 = window.getMaximumSize();
        if (n > dimension2.width) {
            n = dimension2.width;
        }
        if (n2 > dimension2.height) {
            n2 = dimension2.height;
        }
        if (n != dimension.width || n2 != dimension.height) {
            window.setSize(n, n2);
        }
    }
}

