/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.menu.file.CloseCommand;
import com.trollworks.ttk.preferences.Preferences;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.utility.WindowSizeEnforcer;
import com.trollworks.ttk.widgets.CommitEnforcer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class BaseWindow
extends JFrame
implements WindowListener,
WindowFocusListener {
    private static final String WINDOW_PREFERENCES = "WindowPrefs";
    private static final int WINDOW_PREFERENCES_VERSION = 3;
    private static final String KEY_LOCATION = "Location";
    private static final String KEY_SIZE = "Size";
    private static final String KEY_MAXIMIZED = "Maximized";
    private static final String KEY_LAST_UPDATED = "LastUpdated";
    private boolean mWasAlive;
    private boolean mIsClosed;

    public static boolean hasOwnedWindowsShowing(Window window) {
        for (Window window2 : window.getOwnedWindows()) {
            if (!window2.isShowing()) continue;
            return true;
        }
        return false;
    }

    public static <T extends BaseWindow> ArrayList<T> getWindows(Class<T> clazz) {
        Frame[] frameArray;
        ArrayList<BaseWindow> arrayList = new ArrayList<BaseWindow>();
        for (Frame frame : frameArray = Frame.getFrames()) {
            if (!clazz.isInstance(frame)) continue;
            BaseWindow baseWindow = (BaseWindow)clazz.cast(frame);
            if (!baseWindow.mWasAlive || baseWindow.isClosed()) continue;
            arrayList.add(baseWindow);
        }
        return arrayList;
    }

    public static <T extends BaseWindow> String getNextUntitledWindowName(Class<T> clazz, String string, BaseWindow baseWindow) {
        String string2;
        ArrayList<BaseWindow> arrayList = BaseWindow.getWindows(clazz);
        int n = 0;
        block0: do {
            string2 = string;
            if (++n > 1) {
                string2 = string2 + " " + n;
            }
            for (BaseWindow baseWindow2 : arrayList) {
                if (baseWindow2 == baseWindow || !string2.equals(baseWindow2.getTitle())) continue;
                string2 = null;
                continue block0;
            }
        } while (string2 == null);
        return string2;
    }

    public BaseWindow(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.setDefaultCloseOperation(0);
        this.setLocationByPlatform(true);
        ((JComponent)this.getContentPane()).setDoubleBuffered(true);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        this.addWindowListener(this);
        this.addWindowFocusListener(this);
        new WindowSizeEnforcer(this);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.mWasAlive = true;
        }
        super.setVisible(bl);
    }

    public void invalidate(Component component) {
        component.invalidate();
        component.repaint();
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.invalidate(component2);
            }
        }
    }

    public final boolean isClosed() {
        return this.mIsClosed;
    }

    @Override
    public void dispose() {
        if (!this.mIsClosed) {
            try {
                this.saveBounds();
                super.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mIsClosed = true;
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        CloseCommand.INSTANCE.close(this, true);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        CommitEnforcer.forceFocusToAccept();
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        CommitEnforcer.forceFocusToAccept();
    }

    public String getWindowPrefsPrefix() {
        return null;
    }

    public Preferences getWindowPreferences() {
        return Preferences.getInstance();
    }

    public void saveBounds() {
        String string = this.getWindowPrefsPrefix();
        if (string != null) {
            boolean bl;
            Preferences preferences = this.getWindowPreferences();
            boolean bl2 = bl = (this.getExtendedState() & 6) != 0;
            if (bl || this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            preferences.startBatch();
            preferences.setValue(WINDOW_PREFERENCES, string + KEY_LOCATION, this.getLocation());
            preferences.setValue(WINDOW_PREFERENCES, string + KEY_SIZE, this.getSize());
            preferences.setValue(WINDOW_PREFERENCES, string + KEY_MAXIMIZED, bl);
            preferences.setValue(WINDOW_PREFERENCES, string + KEY_LAST_UPDATED, System.currentTimeMillis());
            preferences.endBatch();
        }
    }

    public void restoreBounds() {
        Preferences preferences = this.getWindowPreferences();
        preferences.resetIfVersionMisMatch(WINDOW_PREFERENCES, 3);
        this.pruneOldWindowPreferences(preferences);
        boolean bl = true;
        String string = this.getWindowPrefsPrefix();
        if (string != null) {
            Dimension dimension;
            Point point = preferences.getPointValue(WINDOW_PREFERENCES, string + KEY_LOCATION);
            if (point != null) {
                this.setLocation(point);
            }
            if ((dimension = preferences.getDimensionValue(WINDOW_PREFERENCES, string + KEY_SIZE)) != null) {
                this.setSize(dimension);
                bl = false;
            }
        }
        if (bl) {
            this.pack();
        }
        GraphicsUtilities.forceOnScreen(this);
        if (preferences.getBooleanValue(WINDOW_PREFERENCES, string + KEY_MAXIMIZED, false)) {
            this.setExtendedState(6);
        }
    }

    private void pruneOldWindowPreferences(Preferences preferences) {
        long l = System.currentTimeMillis() - 3888000000L;
        List<String> list = preferences.getModuleKeys(WINDOW_PREFERENCES);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!string.endsWith(KEY_LAST_UPDATED) || preferences.getLongValue(WINDOW_PREFERENCES, string, 0L) >= l) continue;
            arrayList.add(string.substring(0, string.length() - KEY_LAST_UPDATED.length()));
        }
        if (!arrayList.isEmpty()) {
            block1: for (String string : list) {
                for (String string2 : arrayList) {
                    if (!string.startsWith(string2)) continue;
                    preferences.removePreference(WINDOW_PREFERENCES, string);
                    continue block1;
                }
            }
        }
    }
}

