/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public enum BoundaryArea {
    LEFT{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.x = rectangle2.x + n;
            rectangle.width = rectangle2.width - n;
            if (rectangle.width < 1) {
                rectangle.x = rectangle2.x + rectangle2.width - 1;
                rectangle.width = 1;
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(10);
        }
    }
    ,
    RIGHT{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.width = rectangle2.width + n;
            if (rectangle.width < 1) {
                rectangle.width = 1;
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(11);
        }
    }
    ,
    TOP{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.y = rectangle2.y + n2;
            rectangle.height = rectangle2.height - n2;
            if (rectangle.height < 1) {
                rectangle.y = rectangle2.y + rectangle2.height - 1;
                rectangle.height = 1;
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(8);
        }
    }
    ,
    BOTTOM{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.height = rectangle2.height + n2;
            if (rectangle.height < 1) {
                rectangle.height = 1;
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(9);
        }
    }
    ,
    TOP_LEFT{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            TOP.adjust(n, n2, rectangle, rectangle2);
            LEFT.adjust(n, n2, rectangle, rectangle2);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(6);
        }
    }
    ,
    TOP_RIGHT{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            TOP.adjust(n, n2, rectangle, rectangle2);
            RIGHT.adjust(n, n2, rectangle, rectangle2);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(7);
        }
    }
    ,
    BOTTOM_LEFT{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            BOTTOM.adjust(n, n2, rectangle, rectangle2);
            LEFT.adjust(n, n2, rectangle, rectangle2);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(4);
        }
    }
    ,
    BOTTOM_RIGHT{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            BOTTOM.adjust(n, n2, rectangle, rectangle2);
            RIGHT.adjust(n, n2, rectangle, rectangle2);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(5);
        }
    }
    ,
    INTERIOR{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.x = rectangle2.x + n;
            rectangle.y = rectangle2.y + n2;
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(13);
        }
    }
    ,
    OUTSIDE{

        @Override
        public void adjust(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getDefaultCursor();
        }
    };

    private static final int SLOP = 5;
    private static final int TWICE_SLOP = 10;
    private static final int HANDLE = 7;
    private static final int HALF_HANDLE = 3;

    public abstract void adjust(int var1, int var2, Rectangle var3, Rectangle var4);

    public abstract Cursor getCursor();

    public static final BoundaryArea over(Point point, Rectangle rectangle) {
        return BoundaryArea.over(point.x, point.y, rectangle);
    }

    public static final BoundaryArea over(int n, int n2, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x - 5, rectangle.y - 5, rectangle.width + 10, rectangle.height + 10);
        if (rectangle2.contains(n, n2)) {
            boolean bl = BoundaryArea.over(n2, rectangle.y);
            boolean bl2 = BoundaryArea.over(n2, rectangle.y + rectangle.height);
            if (BoundaryArea.over(n, rectangle.x)) {
                if (bl) {
                    return TOP_LEFT;
                }
                if (bl2) {
                    return BOTTOM_LEFT;
                }
                return LEFT;
            }
            if (BoundaryArea.over(n, rectangle.x + rectangle.width)) {
                if (bl) {
                    return TOP_RIGHT;
                }
                if (bl2) {
                    return BOTTOM_RIGHT;
                }
                return RIGHT;
            }
            if (bl) {
                return TOP;
            }
            if (bl2) {
                return BOTTOM;
            }
            if (rectangle.contains(n, n2)) {
                return INTERIOR;
            }
        }
        return OUTSIDE;
    }

    private static final boolean over(int n, int n2) {
        return n > n2 - 5 && n < n2 + 5;
    }

    public static final void drawHandles(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.y - 3;
        int n2 = rectangle.y + rectangle.height / 2 - 3;
        int n3 = rectangle.y + rectangle.height - 3;
        int n4 = rectangle.x - 3;
        int n5 = rectangle.x + rectangle.width / 2 - 3;
        int n6 = rectangle.x + rectangle.width - 3;
        graphics.fillRect(n4, n, 7, 7);
        graphics.fillRect(n5, n, 7, 7);
        graphics.fillRect(n6, n, 7, 7);
        graphics.fillRect(n4, n2, 7, 7);
        graphics.fillRect(n6, n2, 7, 7);
        graphics.fillRect(n4, n3, 7, 7);
        graphics.fillRect(n5, n3, 7, 7);
        graphics.fillRect(n6, n3, 7, 7);
        graphics.fillRect(n5, n2, 7, 7);
    }
}

