/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class LinkedLabel
extends JLabel
implements PropertyChangeListener {
    public static final String ERROR_MESSAGE_KEY = "Error Message";
    private JComponent mLink;
    private Color mColor = this.getForeground();

    public LinkedLabel(ImageIcon imageIcon) {
        super(imageIcon);
    }

    public LinkedLabel(ImageIcon imageIcon, JComponent jComponent) {
        super(imageIcon);
        this.setLink(jComponent);
    }

    public LinkedLabel(String string) {
        this(string, 4);
    }

    public LinkedLabel(String string, int n) {
        super(string, n);
    }

    public LinkedLabel(String string, String string2) {
        this(string);
        this.setFont(UIManager.getFont(string2));
    }

    public LinkedLabel(String string, String string2, int n) {
        this(string, n);
        this.setFont(UIManager.getFont(string2));
    }

    public LinkedLabel(String string, JComponent jComponent) {
        this(string);
        this.setLink(jComponent);
    }

    public LinkedLabel(String string, String string2, JComponent jComponent) {
        this(string, string2);
        this.setLink(jComponent);
    }

    public LinkedLabel(String string, String string2, JComponent jComponent, int n) {
        this(string, string2, n);
        this.setLink(jComponent);
    }

    public JComponent getLink() {
        return this.mLink;
    }

    public void setLink(JComponent jComponent) {
        if (this.mLink != jComponent) {
            if (this.mLink != null) {
                this.mLink.removePropertyChangeListener("ToolTipText", this);
                this.mLink.removePropertyChangeListener(ERROR_MESSAGE_KEY, this);
            }
            this.mLink = jComponent;
            if (this.mLink != null) {
                this.mLink.addPropertyChangeListener("ToolTipText", this);
                this.mLink.addPropertyChangeListener(ERROR_MESSAGE_KEY, this);
            }
            this.adjustToLink();
        }
    }

    private void adjustToLink() {
        Color color;
        String string;
        if (this.mLink != null) {
            string = (String)this.mLink.getClientProperty(ERROR_MESSAGE_KEY);
            if (string == null) {
                string = this.mLink.getToolTipText();
                color = this.mColor;
            } else {
                color = Color.RED;
            }
        } else {
            string = null;
            color = this.mColor;
        }
        this.setToolTipText(string);
        super.setForeground(color);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.adjustToLink();
    }

    @Override
    public void setForeground(Color color) {
        this.mColor = color;
        if (this.mLink == null || this.mLink.getClientProperty(ERROR_MESSAGE_KEY) == null) {
            super.setForeground(color);
        }
    }

    public static void setErrorMessage(JComponent jComponent, String string) {
        Object object = jComponent.getClientProperty(ERROR_MESSAGE_KEY);
        if (object == null ? string != null : !object.equals(string)) {
            jComponent.putClientProperty(ERROR_MESSAGE_KEY, string);
        }
    }
}

