/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.menu.file.RecentFilesMenu;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.NewerDataFileVersionException;
import com.trollworks.ttk.utility.Path;
import com.trollworks.ttk.utility.Platform;
import com.trollworks.ttk.widgets.WindowUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.HashSet;

public class StdFileDialog
implements FilenameFilter {
    private static String MSG_UNABLE_TO_OPEN;
    private static String MSG_UNABLE_TO_OPEN_WITH_EXCEPTION;
    private HashSet<String> mFileNameMatchers = new HashSet();

    public static File choose(Component component, boolean bl, String string, String string2, String string3, String ... stringArray) {
        StdFileDialog stdFileDialog = new StdFileDialog(stringArray);
        Window window = WindowUtils.getWindowForComponent(component);
        int n = bl ? 0 : 1;
        FileDialog fileDialog = window instanceof Frame ? new FileDialog((Frame)window, string, n) : new FileDialog((Dialog)window, string, n);
        fileDialog.setFilenameFilter(stdFileDialog);
        fileDialog.setDirectory(string2);
        fileDialog.setFile(string3);
        fileDialog.setVisible(true);
        String string4 = fileDialog.getFile();
        if (string4 != null) {
            if (stdFileDialog.accept(null, string4)) {
                File file = new File(fileDialog.getDirectory(), string4);
                RecentFilesMenu.addRecent(file);
                return file;
            }
            if (!bl) {
                File file = new File(fileDialog.getDirectory(), Path.enforceExtension(string4, stringArray[0]));
                RecentFilesMenu.addRecent(file);
                return file;
            }
            StdFileDialog.showCannotOpenMsg(component, string4, null);
        }
        return null;
    }

    public static void showCannotOpenMsg(Component component, String string, Exception exception) {
        if (exception instanceof NewerDataFileVersionException) {
            WindowUtils.showError(component, MessageFormat.format(MSG_UNABLE_TO_OPEN_WITH_EXCEPTION, string, exception.getMessage()));
        } else {
            WindowUtils.showError(component, MessageFormat.format(MSG_UNABLE_TO_OPEN, string));
        }
    }

    public static String createExtensionMatcher(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (Platform.isMacintosh() || Platform.isWindows()) {
            stringBuilder.append("(?i)");
        }
        stringBuilder.append("^.*\\");
        if (!string.startsWith(".")) {
            stringBuilder.append('.');
        }
        stringBuilder.append(string);
        stringBuilder.append('$');
        return stringBuilder.toString();
    }

    private StdFileDialog(String ... stringArray) {
        for (String string : stringArray) {
            this.mFileNameMatchers.add(StdFileDialog.createExtensionMatcher(string));
        }
    }

    @Override
    public boolean accept(File file, String string) {
        if (this.mFileNameMatchers.isEmpty()) {
            return true;
        }
        for (String string2 : this.mFileNameMatchers) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    static {
        LocalizedMessages.initialize(StdFileDialog.class);
    }
}

