/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.WindowSizeEnforcer;
import com.trollworks.ttk.widgets.KeyStrokeDisplay;
import com.trollworks.ttk.widgets.MyBasicOptionPaneUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;

public class WindowUtils {
    private static String MSG_ERROR;
    private static String MSG_WARNING;

    public static void showError(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, MSG_ERROR, 0);
    }

    public static void showWarning(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, MSG_WARNING, 2);
    }

    public static int showConfirmDialog(Component component, String string, String string2, int n, Object[] objectArray, Object object) {
        return WindowUtils.showOptionDialog(component, string, string2, false, n, 3, null, objectArray, object);
    }

    public static int showOptionDialog(Component component, Object object, String string, boolean bl, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        jOptionPane.setUI(new MyBasicOptionPaneUI(jOptionPane.getUI()));
        jOptionPane.setInitialValue(object2);
        jOptionPane.setComponentOrientation((component == null ? JOptionPane.getRootFrame() : component).getComponentOrientation());
        final JDialog jDialog = jOptionPane.createDialog(WindowUtils.getWindowForComponent(component), string);
        new WindowSizeEnforcer(jDialog);
        jOptionPane.selectInitialValue();
        jDialog.setResizable(bl);
        final Component component2 = WindowUtils.getFirstFocusableField(object);
        if (component2 != null) {
            jDialog.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    component2.requestFocus();
                    jDialog.removeWindowFocusListener(this);
                }
            });
        }
        jDialog.setVisible(true);
        jDialog.dispose();
        jOptionPane.setMessage(null);
        Object object3 = jOptionPane.getValue();
        if (object3 != null) {
            if (objectArray == null) {
                if (object3 instanceof Integer) {
                    return (Integer)object3;
                }
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].equals(object3)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private static Component getFirstFocusableField(Object object) {
        if (object instanceof JTextComponent || object instanceof KeyStrokeDisplay) {
            return (Component)object;
        }
        if (object instanceof Container) {
            for (Component component : ((Container)object).getComponents()) {
                Component component2 = WindowUtils.getFirstFocusableField(component);
                if (component2 == null) continue;
                return component2;
            }
        }
        return null;
    }

    public static Window getWindowForComponent(Component component) {
        while (component != null) {
            if (component instanceof Frame || component instanceof Dialog) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return JOptionPane.getRootFrame();
    }

    static {
        LocalizedMessages.initialize(WindowUtils.class);
    }
}

