/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.Outline;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class OutlineHeader
extends JPanel
implements DragGestureListener,
DropTargetListener,
DragSourceListener,
MouseListener,
MouseMotionListener {
    private Outline mOwner;
    private Column mSortColumn;
    private boolean mResizeOK;
    private boolean mIgnoreResizeOK;
    private Color mTopDividerColor;

    public OutlineHeader(Outline outline) {
        this.mOwner = outline;
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setAutoscrolls(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        if (!GraphicsUtilities.inHeadlessPrintMode()) {
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, this);
            this.setDropTarget(new DropTarget(this, this));
        }
    }

    public Color getTopDividerColor() {
        return this.mTopDividerColor == null ? this.mOwner.getDividerColor() : this.mTopDividerColor;
    }

    public void setTopDividerColor(Color color) {
        this.mTopDividerColor = color;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Column column = this.mOwner.overColumn(mouseEvent.getX());
            if (column != null && this.mOwner.allowColumnContextMenu()) {
                ArrayList<Column> arrayList = new ArrayList<Column>();
                arrayList.add(column);
            }
        } else if (this.mOwner.overColumnDivider(mouseEvent.getX()) == null) {
            this.mSortColumn = this.mOwner.overColumn(mouseEvent.getX());
        } else {
            this.mOwner.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mSortColumn != null) {
            if (this.mSortColumn == this.mOwner.overColumn(mouseEvent.getX()) && this.mOwner.isUserSortable()) {
                boolean bl = this.mSortColumn.isSortAscending();
                if (this.mSortColumn.getSortSequence() != -1) {
                    bl = !bl;
                }
                this.mOwner.setSort(this.mSortColumn, bl, mouseEvent.isShiftDown());
            }
            this.mSortColumn = null;
        } else {
            this.mOwner.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mOwner.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = Cursor.getDefaultCursor();
        int n = mouseEvent.getX();
        if (this.mOwner.overColumnDivider(n) != null) {
            if (this.mOwner.allowColumnResize()) {
                cursor = Cursor.getPredefinedCursor(10);
            }
        } else if (this.mOwner.overColumn(n) != null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        this.setCursor(cursor);
    }

    public Outline getOwner() {
        return this.mOwner;
    }

    @Override
    public Dimension getPreferredSize() {
        List<Column> list = this.mOwner.getModel().getColumns();
        boolean bl = this.mOwner.shouldDrawColumnDividers();
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, 0);
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : list) {
            if (!column.isVisible()) continue;
            int n = column.getWidth();
            if (n == -1) {
                n = column.getPreferredWidth(this.mOwner);
                column.setWidth(n);
                arrayList.add(column);
            }
            dimension.width = dimension.width + (n + (bl ? 1 : 0));
            n = column.getPreferredHeaderHeight() + 1;
            if (n <= dimension.height) continue;
            dimension.height = n;
        }
        if (!arrayList.isEmpty()) {
            this.mOwner.updateRowHeightsIfNeeded(arrayList);
            this.mOwner.revalidateView();
        }
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(GraphicsUtilities.prepare(graphics));
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.getInsets();
        int n = this.getHeight();
        Rectangle rectangle2 = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), n - (insets.top + insets.bottom));
        boolean bl = this.mOwner.shouldDrawColumnDividers();
        graphics.setColor(this.getTopDividerColor());
        graphics.drawLine(rectangle.x, n - 1, rectangle.x + rectangle.width, n - 1);
        Color color = this.mOwner.getDividerColor();
        for (Column column : this.mOwner.getModel().getColumns()) {
            if (!column.isVisible()) continue;
            rectangle2.width = column.getWidth();
            if (rectangle.intersects(rectangle2)) {
                boolean bl2 = this.mOwner.getSourceDragColumn() == column;
                Composite composite = null;
                if (bl2) {
                    composite = ((Graphics2D)graphics).getComposite();
                    ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                column.drawHeaderCell(this.mOwner, graphics, rectangle2);
                if (bl2) {
                    ((Graphics2D)graphics).setComposite(composite);
                }
            }
            rectangle2.x += rectangle2.width;
            if (!bl) continue;
            graphics.setColor(color);
            graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, rectangle2.y + rectangle2.height);
            ++rectangle2.x;
        }
    }

    @Override
    public void repaint(Rectangle rectangle) {
        if (this.mOwner != null) {
            this.mOwner.repaintHeader(rectangle);
        }
    }

    void repaintInternal(Rectangle rectangle) {
        super.repaint(rectangle);
    }

    public Rectangle getColumnBounds(Column column) {
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
        rectangle.x = this.mOwner.getColumnStart(column);
        rectangle.width = column.getWidth();
        return rectangle;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Column column = this.mOwner.overColumn(mouseEvent.getX());
        if (column != null) {
            return column.getHeaderCell().getToolTipText(mouseEvent, this.getColumnBounds(column), null, column);
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.mSortColumn != null && this.mOwner.allowColumnDrag()) {
            this.mOwner.setSourceDragColumn(this.mSortColumn);
            if (DragSource.isDragImageSupported()) {
                Point point = dragGestureEvent.getDragOrigin();
                dragGestureEvent.startDrag(null, this.mOwner.getColumnDragImage(this.mSortColumn), new Point(-(point.x - this.mOwner.getColumnStart(this.mSortColumn)), -point.y), this.mSortColumn, this);
            } else {
                dragGestureEvent.startDrag(null, this.mSortColumn, this);
            }
            this.mSortColumn = null;
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mOwner.getSourceDragColumn() != null) {
            this.mOwner.dragEnter(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mOwner.getSourceDragColumn() != null) {
            this.mOwner.dragOver(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mOwner.getSourceDragColumn() != null) {
            this.mOwner.dropActionChanged(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.mOwner.getSourceDragColumn() != null) {
            this.mOwner.dragExit(dropTargetEvent);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.mOwner.drop(dropTargetDropEvent);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.mIgnoreResizeOK || this.mResizeOK) {
            super.setBounds(n, n2, n3, n4);
        }
    }

    void setResizeOK(boolean bl) {
        this.mResizeOK = bl;
    }

    public void setIgnoreResizeOK(boolean bl) {
        this.mIgnoreResizeOK = bl;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.mOwner.setSourceDragColumn(null);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }
}

