/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.text.NumericStringComparator;
import com.trollworks.ttk.text.TextDrawing;
import com.trollworks.ttk.utility.Fonts;
import com.trollworks.ttk.widgets.tree.TreeColumn;
import com.trollworks.ttk.widgets.tree.TreePanel;
import com.trollworks.ttk.widgets.tree.TreeRow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;

public class TextTreeColumn
extends TreeColumn {
    private static final int ICON_GAP = 2;
    private static final int HMARGIN = 2;
    private String mField;
    private String mIconField;
    private int mAlignment;
    private int mTruncationPolicy;
    private boolean mWrapped;

    public TextTreeColumn(String string, String string2) {
        this(string, string2, 2);
    }

    public TextTreeColumn(String string, String string2, int n) {
        this(string, string2, null, n, false);
    }

    public TextTreeColumn(String string, String string2, int n, boolean bl) {
        this(string, string2, null, n, bl);
    }

    public TextTreeColumn(String string, String string2, String string3) {
        this(string, string2, string3, 2);
    }

    public TextTreeColumn(String string, String string2, String string3, int n) {
        this(string, string2, string3, n, false);
    }

    public TextTreeColumn(String string, String string2, String string3, int n, boolean bl) {
        super(string);
        this.mField = this.createMethodName(string2);
        this.mIconField = this.createMethodName(string3);
        this.mAlignment = n;
        this.mWrapped = bl;
    }

    private String createMethodName(String string) {
        if (string != null) {
            return "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return null;
    }

    @Override
    public int calculatePreferredHeight(TreeRow treeRow, int n) {
        Font font = this.getFont(treeRow);
        n -= 4;
        BufferedImage bufferedImage = this.getIcon(treeRow);
        if (bufferedImage != null) {
            n -= bufferedImage.getWidth() + 2;
        }
        String string = this.getPresentationText(treeRow, font, n);
        return this.calculatePreferredHeight(font, string, bufferedImage);
    }

    private int calculatePreferredHeight(Font font, String string, BufferedImage bufferedImage) {
        int n = this.getSingleLineHeight(font);
        int n2 = TextDrawing.getPreferredSize((Font)font, (String)string).height;
        if (bufferedImage != null) {
            n2 = Math.max(n2, bufferedImage.getHeight());
        }
        return Math.max(n, n2);
    }

    private int getSingleLineHeight(Font font) {
        return TextDrawing.getPreferredSize((Font)font, (String)"Mg").height;
    }

    @Override
    public int calculatePreferredWidth(TreeRow treeRow) {
        int n = TextDrawing.getPreferredSize((Font)this.getFont((TreeRow)treeRow), (String)this.getText((TreeRow)treeRow)).width;
        BufferedImage bufferedImage = this.getIcon(treeRow);
        if (bufferedImage != null) {
            n += bufferedImage.getWidth() + 2;
        }
        return 2 + n + 2;
    }

    @Override
    public void draw(Graphics2D graphics2D, TreePanel treePanel, TreeRow treeRow, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        n3 += 2;
        n4 -= 4;
        BufferedImage bufferedImage = this.getIcon(treeRow);
        if (bufferedImage != null) {
            graphics2D.drawImage((Image)bufferedImage, n3, n2, null);
            int n5 = bufferedImage.getWidth() + 2;
            n3 += n5;
            n4 -= n5;
        }
        Font font = this.getFont(treeRow);
        graphics2D.setFont(font);
        String string = this.getPresentationText(treeRow, font, n4);
        int n6 = this.calculatePreferredHeight(font, string, bufferedImage);
        graphics2D.setColor(this.getColor(treePanel, treeRow, n, bl, bl2));
        TextDrawing.draw(graphics2D, new Rectangle(n3, n2, n4, n6), string, this.mAlignment, 1);
    }

    protected String getPresentationText(TreeRow treeRow, Font font, int n) {
        String string = this.getText(treeRow);
        if (this.mWrapped) {
            return TextDrawing.wrapToPixelWidth(font, string, n);
        }
        return TextDrawing.truncateIfNecessary(font, string, n, this.mTruncationPolicy);
    }

    protected String getText(TreeRow treeRow) {
        return TextTreeColumn.getFieldContents(treeRow, this.mField, "");
    }

    protected BufferedImage getIcon(TreeRow treeRow) {
        return TextTreeColumn.getFieldContents(treeRow, this.mIconField, null);
    }

    private static <T> T getFieldContents(TreeRow treeRow, String string, T object) {
        if (string != null) {
            try {
                Method method = treeRow.getClass().getMethod(string, null);
                Object object2 = method.invoke((Object)treeRow, (Object[])null);
                if (object2 != null) {
                    object = object2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    public Font getFont(TreeRow treeRow) {
        return Fonts.getDefaultFont();
    }

    public Color getColor(TreePanel treePanel, TreeRow treeRow, int n, boolean bl, boolean bl2) {
        return treePanel.getDefaultRowForeground(n, bl, bl2);
    }

    @Override
    public int compare(TreeRow treeRow, TreeRow treeRow2) {
        return NumericStringComparator.caselessCompareStrings(this.getText(treeRow), this.getText(treeRow2));
    }
}

