/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.image.ToolkitImage;
import com.trollworks.ttk.menu.edit.Deletable;
import com.trollworks.ttk.menu.edit.Openable;
import com.trollworks.ttk.menu.edit.SelectAllCapable;
import com.trollworks.ttk.notification.NotifierTarget;
import com.trollworks.ttk.text.TextDrawing;
import com.trollworks.ttk.utility.Colors;
import com.trollworks.ttk.utility.Debug;
import com.trollworks.ttk.utility.DelayedTask;
import com.trollworks.ttk.utility.Fonts;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.widgets.DirectScrollPanel;
import com.trollworks.ttk.widgets.DirectScrollPanelArea;
import com.trollworks.ttk.widgets.tree.TreeColumn;
import com.trollworks.ttk.widgets.tree.TreeColumnDragState;
import com.trollworks.ttk.widgets.tree.TreeContainerRow;
import com.trollworks.ttk.widgets.tree.TreeDragState;
import com.trollworks.ttk.widgets.tree.TreeRoot;
import com.trollworks.ttk.widgets.tree.TreeRow;
import com.trollworks.ttk.widgets.tree.TreeRowDragState;
import com.trollworks.ttk.widgets.tree.TreeRowIterator;
import com.trollworks.ttk.widgets.tree.TreeRowSelection;
import com.trollworks.ttk.widgets.tree.TreeRowViewIterator;
import com.trollworks.ttk.widgets.tree.TreeSorter;
import gnu.trove.TObjectIntHashMap;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.UIManager;

public class TreePanel
extends DirectScrollPanel
implements Openable,
Deletable,
SelectAllCapable,
DropTargetListener,
DragSourceListener,
DragGestureListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
NotifierTarget {
    public static final int HIT_SLOP = 4;
    private static final int DRAG_FOCUS_WIDTH = 3;
    private static final int DRAG_INSERT_WIDTH = 3;
    public static final int INDENT = 25;
    private final Runnable DEFERRED_RESIZER = new Runnable(){

        @Override
        public void run() {
            TreePanel.this.mResizePending = false;
            TreePanel.this.setHeaderSize(TreePanel.this.getPreferredHeaderSize());
            TreePanel.this.setContentSize(TreePanel.this.getPreferredContentSize());
            if (TreePanel.this.mResizeRow != null) {
                TreePanel.this.scrollContentToY(TreePanel.this.getRowBounds((TreeRow)TreePanel.this.mResizeRow).y);
                TreePanel.this.mResizeRow = null;
            }
        }
    };
    private TreeRoot mRoot;
    private ArrayList<TreeColumn> mColumns = new ArrayList();
    private DirectScrollPanelArea mViewArea;
    private Deletable mDeletableProxy;
    private Openable mOpenableProxy;
    private Point mDragStart;
    private Color mRowDividerColor;
    private Color mColumnDividerColor = this.mRowDividerColor = Color.GRAY;
    private Color mHierarchyLineColor = new Color(120, 152, 181);
    private HashSet<TreeContainerRow> mOpenRows = new HashSet();
    private HashSet<TreeRow> mSelectedRows = new HashSet();
    private TObjectIntHashMap<TreeRow> mRowHeightMap = new TObjectIntHashMap();
    private int mRowHeight;
    private int mMouseOverColumnDivider;
    private int mDragColumnDivider;
    private int mAllowedRowDragTypes;
    private int mAllowedRowDropTypes;
    private TreeSorter mSorter;
    private TreeColumn mSortColumn;
    private TreeColumn mSourceDragColumn;
    private TreeDragState mDragState;
    private TreeRow mAnchorRow;
    private TreeRow mRowToSelectOnMouseUp;
    TreeRow mResizeRow;
    private boolean mShowDisclosureControls;
    private boolean mUseBanding;
    private boolean mAllowColumnResize;
    private boolean mAllowColumnDrag;
    private boolean mAllowColumnContextMenu;
    private boolean mAllowRowDropFromExternal;
    private boolean mUserSortable;
    private boolean mDropReceived;
    boolean mResizePending;

    public TreePanel(TreeRoot treeRoot) {
        this.mRowHeight = TextDrawing.getPreferredSize((Font)Fonts.getDefaultFont(), (String)"Mg").height;
        this.mMouseOverColumnDivider = -1;
        this.mDragColumnDivider = -1;
        this.mAllowedRowDragTypes = 3;
        this.mAllowedRowDropTypes = 3;
        this.mSorter = new TreeSorter();
        this.mShowDisclosureControls = true;
        this.mUseBanding = true;
        this.mAllowColumnResize = true;
        this.mAllowColumnDrag = true;
        this.mAllowColumnContextMenu = true;
        this.mAllowRowDropFromExternal = false;
        this.mUserSortable = true;
        this.mRoot = treeRoot;
        this.mRoot.getNotifier().add(this, "tree.row.removed");
        this.setUnitIncrement(this.mRowHeight + this.getRowDividerHeight());
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        if (!GraphicsUtilities.inHeadlessPrintMode()) {
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, this);
            this.setDropTarget(new DropTarget(this, this));
        }
    }

    public TreeRoot getRoot() {
        return this.mRoot;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        DirectScrollPanelArea directScrollPanelArea = this.checkAndConvertToArea(point);
        if (directScrollPanelArea != DirectScrollPanelArea.NONE) {
            this.setColumnDividerHighlight(point.x);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mDragColumnDivider != -1) {
            this.clearColumnDividerHighlight();
        }
    }

    private boolean setColumnDividerHighlight(int n) {
        int n2 = this.mMouseOverColumnDivider;
        int n3 = this.mAllowColumnResize ? this.overColumnDivider(n) : -1;
        this.setCursor(n3 == -1 ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(10));
        this.mMouseOverColumnDivider = n3;
        if (n2 != n3) {
            this.repaintDivider(n2);
            this.repaintDivider(n3);
        }
        return n3 != -1;
    }

    private void clearColumnDividerHighlight() {
        if (this.mMouseOverColumnDivider != -1) {
            this.repaintDivider(this.mMouseOverColumnDivider);
            this.mMouseOverColumnDivider = -1;
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void repaintDivider(int n) {
        if (n != -1) {
            int n2 = this.getColumnDividerPosition(n);
            this.repaintHeaderView(n2 - 1, 0, 3, Integer.MAX_VALUE);
            this.repaintContentView(n2 - 1, 0, 3, Integer.MAX_VALUE);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.mRowToSelectOnMouseUp = null;
        this.mViewArea = this.checkAndConvertToArea(point);
        if (this.mViewArea != DirectScrollPanelArea.NONE) {
            this.mDragStart = new Point(point);
            if (this.setColumnDividerHighlight(this.mDragStart.x)) {
                this.mDragColumnDivider = this.mMouseOverColumnDivider;
            } else {
                switch (this.mViewArea) {
                    case CONTENT: {
                        TreeContainerRow treeContainerRow = this.overDisclosureControl(this.mDragStart.x, this.mDragStart.y);
                        if (treeContainerRow != null) {
                            this.setOpen(!this.isOpen(treeContainerRow), treeContainerRow);
                            break;
                        }
                        TreeRow treeRow = this.overRow(this.mDragStart.y);
                        if (treeRow != null) {
                            if (this.mAnchorRow != null && mouseEvent.isShiftDown()) {
                                this.select(this.mAnchorRow, treeRow, true);
                            } else if ((mouseEvent.getModifiers() & this.getToolkit().getMenuShortcutKeyMask()) != 0 && !mouseEvent.isPopupTrigger()) {
                                if (this.isSelected(treeRow)) {
                                    this.deselect(treeRow);
                                } else {
                                    this.select(treeRow, true);
                                }
                            } else if (!this.isSelected(treeRow)) {
                                this.select(treeRow, false);
                            } else if (this.mSelectedRows.size() != 1) {
                                this.mRowToSelectOnMouseUp = treeRow;
                            }
                        } else {
                            this.deselect();
                        }
                        if (!mouseEvent.isPopupTrigger()) break;
                        this.mRowToSelectOnMouseUp = null;
                        this.showContextMenuForContent(point);
                        break;
                    }
                    case HEADER: {
                        TreeColumn treeColumn = this.overColumn(point.x);
                        if (mouseEvent.isPopupTrigger()) {
                            if (treeColumn == null || !this.mAllowColumnContextMenu) break;
                            this.showContextMenuForColumn(point, treeColumn);
                            break;
                        }
                        if (!this.mUserSortable) break;
                        this.mSortColumn = treeColumn;
                        break;
                    }
                }
            }
        }
    }

    protected void showContextMenuForColumn(Point point, TreeColumn treeColumn) {
    }

    protected void showContextMenuForContent(Point point) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mDragColumnDivider != -1) {
            Point point = mouseEvent.getPoint();
            this.mViewArea.convertPoint(this, point);
            this.dragColumnDividerAndScrollIntoView(point);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Point point = mouseEvent.getPoint();
        boolean bl = rectangle.contains(point);
        this.mViewArea.convertPoint(this, point);
        if (this.mDragColumnDivider != -1) {
            this.mDragColumnDivider = -1;
            if (bl) {
                this.setColumnDividerHighlight(point.x);
            } else {
                this.clearColumnDividerHighlight();
            }
        }
        if (this.mRowToSelectOnMouseUp != null) {
            this.select(this.mRowToSelectOnMouseUp, false);
            this.mRowToSelectOnMouseUp = null;
        }
        if (this.mSortColumn != null) {
            if (this.mUserSortable && this.mSortColumn == this.overColumn(point.x)) {
                this.mSorter.setSort(this.mSortColumn, !mouseEvent.isShiftDown());
                this.mSorter.sort(this.mRoot);
                this.repaint();
            }
            this.mSortColumn = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mAllowColumnResize && mouseEvent.getClickCount() == 2) {
            int n;
            Point point = mouseEvent.getPoint();
            this.mViewArea = this.checkAndConvertToArea(point);
            if (this.mViewArea != DirectScrollPanelArea.NONE && (n = this.overColumnDivider(point.x)) != -1) {
                this.sizeColumnToFit(this.mColumns.get(n));
            }
        }
    }

    public TreeSorter getTreeSorter() {
        return this.mSorter;
    }

    private void dragColumnDividerAndScrollIntoView(Point point) {
        if (this.mAllowColumnResize) {
            int n = point.x;
            this.dragColumnDivider(n);
            this.scrollContentIntoView(n - 10, this.getContentViewBounds().y, 20, 20);
        }
    }

    private void dragColumnDivider(int n) {
        TreeColumn treeColumn = this.mColumns.get(this.mDragColumnDivider);
        int n2 = this.getColumnStart(this.mDragColumnDivider);
        int n3 = n2 + treeColumn.getMinimumWidth(this);
        if (this.mShowDisclosureControls && this.mDragColumnDivider == 0) {
            n3 += 25;
        }
        if (n <= n3) {
            n = n3 + 1;
        }
        if ((n -= n2) != treeColumn.getWidth()) {
            if (this.mResizeRow == null) {
                this.mResizeRow = this.overRow(this.getContentViewBounds().y);
            }
            treeColumn.setWidth(n);
            this.invalidateAllRowHeights();
            if (this.isDynamicRowHeightEnabled()) {
                if (!this.mResizePending) {
                    this.mResizePending = true;
                    DelayedTask.schedule(this.DEFERRED_RESIZER, 150L);
                }
            } else {
                this.DEFERRED_RESIZER.run();
            }
            this.repaint();
        }
    }

    public final boolean isUserSortable() {
        return this.mUserSortable;
    }

    public final void setUserSortable(boolean bl) {
        this.mUserSortable = bl;
    }

    public final boolean allowColumnResize() {
        return this.mAllowColumnResize;
    }

    public final void setAllowColumnResize(boolean bl) {
        this.mAllowColumnResize = bl;
    }

    public final boolean allowColumnContextMenu() {
        return this.mAllowColumnContextMenu;
    }

    public final void setAllowColumnContextMenu(boolean bl) {
        this.mAllowColumnContextMenu = bl;
    }

    public final boolean allowColumnDrag() {
        return this.mAllowColumnDrag;
    }

    public final void setAllowColumnDrag(boolean bl) {
        this.mAllowColumnDrag = bl;
    }

    public final int getAllowedRowDragTypes() {
        return this.mAllowedRowDragTypes;
    }

    public final void setAllowedRowDragTypes(int n) {
        this.mAllowedRowDragTypes = n & 3;
    }

    public final int getAllowedRowDropTypes() {
        return this.mAllowedRowDropTypes;
    }

    public final void setAllowedRowDropTypes(int n) {
        this.mAllowedRowDropTypes = n & 3;
    }

    public final boolean allowRowDropFromExternal() {
        return this.mAllowRowDropFromExternal;
    }

    public final void setAllowRowDropFromExternal(boolean bl) {
        this.mAllowRowDropFromExternal = bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public final boolean isDynamicRowHeightEnabled() {
        return this.mRowHeight < 1;
    }

    public final int getRowHeight() {
        return this.mRowHeight;
    }

    public final void setRowHeight(int n) {
        if (this.mRowHeight != n) {
            this.mRowHeight = n;
            this.invalidateAllRowHeights();
        }
    }

    public final int getColumnCount() {
        return this.mColumns.size();
    }

    public final List<TreeColumn> getColumns() {
        return Collections.unmodifiableList(this.mColumns);
    }

    public final TreeColumn getColumn(int n) {
        return this.mColumns.get(n);
    }

    public void addColumn(TreeColumn treeColumn) {
        this.mColumns.add(treeColumn);
        this.notify("tree.column.added", new TreeColumn[]{treeColumn});
    }

    public void addColumn(List<TreeColumn> list) {
        if (this.mColumns.addAll(list)) {
            this.notify("tree.column.added", list.toArray(new TreeColumn[list.size()]));
        }
    }

    public void addColumn(int n, TreeColumn treeColumn) {
        this.mColumns.add(n, treeColumn);
        this.notify("tree.column.added", new TreeColumn[]{treeColumn});
    }

    public void addColumn(int n, List<TreeColumn> list) {
        if (this.mColumns.addAll(n, list)) {
            this.notify("tree.column.added", list.toArray(new TreeColumn[list.size()]));
        }
    }

    public void removeColumn(TreeColumn treeColumn) {
        if (this.mColumns.remove(treeColumn)) {
            this.notify("tree.column.removed", new TreeColumn[]{treeColumn});
        }
    }

    public void removeColumn(Collection<TreeColumn> collection) {
        if (this.mColumns.removeAll(collection)) {
            this.notify("tree.column.removed", collection.toArray(new TreeColumn[collection.size()]));
        }
    }

    protected void restoreColumns(ArrayList<TreeColumn> arrayList) {
        this.mColumns.clear();
        this.mColumns.addAll(arrayList);
        this.repaint();
    }

    @Override
    public Dimension getPreferredHeaderSize() {
        int n = 0;
        int n2 = 0;
        for (TreeColumn treeColumn : this.mColumns) {
            Dimension dimension = treeColumn.calculatePreferredHeaderSize(this);
            n += dimension.width;
            n2 = Math.max(dimension.height, n2);
        }
        int n3 = this.getColumnDividerWidth();
        int n4 = this.mColumns.size() - 1;
        if (n4 > 0) {
            n += n4 * n3;
        }
        return new Dimension(n, n2 += n3);
    }

    @Override
    public Dimension getPreferredContentSize() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getRowDividerHeight();
        for (TreeRow object : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            n2 += this.getRowHeight(object) + n3;
        }
        for (TreeColumn treeColumn : this.mColumns) {
            n += treeColumn.getWidth();
        }
        int n4 = this.mColumns.size() - 1;
        if (n4 > 0) {
            n += n4 * this.getColumnDividerWidth();
        }
        return new Dimension(n, n2);
    }

    public int getColumnStart(int n) {
        int n2 = n * this.getColumnDividerWidth();
        for (int i = 0; i < n; ++i) {
            n2 += this.mColumns.get(i).getWidth();
        }
        return n2;
    }

    public int getColumnStart(TreeColumn treeColumn) {
        int n = this.mColumns.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TreeColumn treeColumn2 = this.mColumns.get(i);
            if (treeColumn2 != treeColumn) {
                n2 += treeColumn2.getWidth();
                continue;
            }
            return n2 + this.getColumnDividerWidth() * i;
        }
        return 0;
    }

    public int getRowHeight(TreeRow treeRow) {
        if (this.mRowHeight > 0) {
            return this.mRowHeight;
        }
        int n = this.mRowHeightMap.get((Object)treeRow);
        if (n == 0) {
            n = this.calculateHeight(treeRow);
            this.mRowHeightMap.put((Object)treeRow, n);
        }
        return n;
    }

    private int calculateHeight(TreeRow treeRow) {
        int n = 0;
        int n2 = this.mColumns.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            TreeColumn treeColumn = this.mColumns.get(i);
            int n4 = treeColumn.getWidth();
            if (this.mShowDisclosureControls && i == 0) {
                n4 -= 25 * treeRow.getDepth();
            }
            if ((n3 = treeColumn.calculatePreferredHeight(treeRow, n4)) <= n) continue;
            n = n3;
        }
        return n;
    }

    public void invalidateRowHeight(TreeRow treeRow) {
        if (this.mRowHeight < 1 && this.mRowHeightMap.remove((Object)treeRow) != 0) {
            this.notify("tree.row.height", new TreeRow[]{treeRow});
        }
    }

    public void invalidateAllRowHeights() {
        if (this.mRowHeight < 1) {
            TreeRow[] treeRowArray = (TreeRow[])this.mRowHeightMap.keys((Object[])new TreeRow[this.mRowHeightMap.size()]);
            this.mRowHeightMap.clear();
            this.notify("tree.row.height", treeRowArray);
        }
    }

    @Override
    public void drawHeader(Graphics2D graphics2D) {
        super.drawHeader(graphics2D);
        boolean bl = this.isFocusOwner();
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        Rectangle rectangle2 = this.getHeaderViewBounds();
        int n3 = this.getColumnDividerWidth();
        rectangle2.x = 0;
        rectangle2.height -= n3;
        int n4 = this.mColumns.size();
        for (int i = 0; i < n4; ++i) {
            TreeColumn treeColumn = this.mColumns.get(i);
            rectangle2.width = i != n4 - 1 ? treeColumn.getWidth() : Math.max(treeColumn.getWidth(), n2 - rectangle2.x);
            if (rectangle2.x < n2 && rectangle2.x + rectangle2.width > n) {
                treeColumn.drawHeader(graphics2D, this, rectangle2, bl);
            }
            rectangle2.x += rectangle2.width + n3;
        }
        if (n3 > 0) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.mColumnDividerColor);
            int n5 = rectangle2.y + rectangle2.height;
            graphics2D.drawLine(n, n5, n2, n5);
            graphics2D.setColor(color);
            this.drawColumnDividers(graphics2D);
        }
        if (!this.isDrawingDragImage() && this.mDragState != null && this.mDragState.isHeaderFocus()) {
            Composite composite = graphics2D.getComposite();
            Color color = graphics2D.getColor();
            this.setHighlightColorAndComposite(graphics2D);
            Rectangle rectangle3 = this.getHeaderViewBounds();
            graphics2D.fillRect(rectangle3.x + 3, rectangle3.y, rectangle3.width - 6, 3);
            if (!this.mDragState.isContentsFocus()) {
                graphics2D.fillRect(rectangle3.x + 3, rectangle3.y + rectangle3.height - 3, rectangle3.width - 6, 3);
            }
            graphics2D.fillRect(rectangle3.x, rectangle3.y, 3, rectangle3.height);
            graphics2D.fillRect(rectangle3.x + rectangle3.width - 3, rectangle3.y, 3, rectangle3.height);
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
        }
    }

    @Override
    public void drawContents(Graphics2D graphics2D) {
        super.drawContents(graphics2D);
        boolean bl = this.isFocusOwner();
        Rectangle rectangle = this.getContentViewBounds();
        int n = rectangle.y;
        int n2 = n + rectangle.height;
        int n3 = 0;
        if (this.mResizePending && this.mResizeRow != null) {
            n3 = n - this.getRowBounds((TreeRow)this.mResizeRow).y;
        }
        int n4 = 0;
        int n5 = this.getRowDividerHeight();
        Rectangle rectangle2 = this.getDragClip();
        boolean bl2 = this.isDrawingDragImage();
        for (Object object : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            int n6 = this.getRowHeight((TreeRow)object) + n5;
            if (n3 + n6 > n) {
                if (bl2) {
                    if (this.mSelectedRows.contains(object)) {
                        if (rectangle2 == null) {
                            rectangle2 = new Rectangle(rectangle.x, n3, rectangle.width, n6);
                        } else {
                            rectangle2.height = n3 + n6 - rectangle2.y;
                        }
                        this.drawRow(graphics2D, (TreeRow)object, n4, n3, bl);
                    }
                } else {
                    this.drawRow(graphics2D, (TreeRow)object, n4, n3, bl);
                }
            }
            if ((n3 += n6) >= n2) break;
            ++n4;
        }
        this.drawColumnDividers(graphics2D);
        if (bl2) {
            this.setDragClip(rectangle2);
        } else if (this.mDragState != null) {
            int n7;
            TreeRowDragState treeRowDragState;
            TreeContainerRow treeContainerRow;
            Object object;
            Composite composite = graphics2D.getComposite();
            object = graphics2D.getColor();
            if (this.mDragState.isContentsFocus()) {
                this.setHighlightColorAndComposite(graphics2D);
                if (!this.mDragState.isHeaderFocus()) {
                    graphics2D.fillRect(rectangle.x + 3, rectangle.y, rectangle.width - 6, 3);
                }
                graphics2D.fillRect(rectangle.x + 3, rectangle.y + rectangle.height - 3, rectangle.width - 6, 3);
                graphics2D.fillRect(rectangle.x, rectangle.y, 3, rectangle.height);
                graphics2D.fillRect(rectangle.x + rectangle.width - 3, rectangle.y, 3, rectangle.height);
            }
            if (this.mDragState instanceof TreeRowDragState && (treeContainerRow = (treeRowDragState = (TreeRowDragState)this.mDragState).getParentRow()) != null && (n7 = treeRowDragState.getChildInsertIndex()) >= 0) {
                n3 = this.getInsertionMarkerPosition(treeContainerRow, n7);
                graphics2D.setColor(Color.RED);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                int n8 = 25 * treeContainerRow.getDepth();
                if (this.mShowDisclosureControls) {
                    n8 += 25;
                }
                graphics2D.fillRect(n8, n3 - 1, rectangle.x + rectangle.width - n8, 3);
            }
            graphics2D.setColor((Color)object);
            graphics2D.setComposite(composite);
        }
    }

    private void drawColumnDividers(Graphics2D graphics2D) {
        int n = this.mColumns.size() - 1;
        if (n > 0) {
            int n2;
            int n3;
            Color color = graphics2D.getColor();
            Rectangle rectangle = graphics2D.getClipBounds();
            int n4 = rectangle.x;
            int n5 = n4 + rectangle.width;
            int n6 = rectangle.y;
            int n7 = n6 + rectangle.height;
            int n8 = this.getColumnDividerWidth();
            if (n8 > 0) {
                n3 = 0;
                graphics2D.setColor(this.mColumnDividerColor);
                for (n2 = 0; n2 < n; ++n2) {
                    if ((n3 += this.mColumns.get(n2).getWidth()) >= n4 && n3 < n5) {
                        graphics2D.drawLine(n3, n6, n3, n7);
                    }
                    n3 += n8;
                }
            }
            if (this.mMouseOverColumnDivider != -1) {
                n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    n3 += this.mColumns.get(n2).getWidth();
                    if (n2 == this.mMouseOverColumnDivider) {
                        if (n3 < n4 || n3 >= n5) break;
                        Composite composite = graphics2D.getComposite();
                        this.setHighlightColorAndComposite(graphics2D);
                        graphics2D.drawLine(n3 - 1, n6, n3 - 1, n7);
                        graphics2D.drawLine(n3 + 1, n6, n3 + 1, n7);
                        graphics2D.setComposite(composite);
                        graphics2D.setColor(Color.BLACK);
                        graphics2D.drawLine(n3, n6, n3, n7);
                        break;
                    }
                    n3 += n8;
                }
            }
            graphics2D.setColor(color);
        }
    }

    private void setHighlightColorAndComposite(Graphics2D graphics2D) {
        graphics2D.setColor(UIManager.getColor("List.selectionBackground"));
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
    }

    public void drawRow(Graphics2D graphics2D, TreeRow treeRow, int n, int n2, boolean bl) {
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        int n3 = this.getRowHeight(treeRow);
        int n4 = n3 + this.getRowDividerHeight();
        int n5 = 0;
        Rectangle rectangle = graphics2D.getClipBounds();
        int n6 = rectangle.x;
        int n7 = rectangle.x + rectangle.width;
        int n8 = this.getColumnDividerWidth();
        int n9 = this.mColumns.size();
        boolean bl2 = this.isSelected(treeRow);
        graphics2D.setColor(this.getDefaultRowBackground(n, bl2, bl));
        graphics2D.fillRect(n6, n2, rectangle.width, n4);
        if (this.mRowDividerColor != null) {
            graphics2D.setColor(this.mRowDividerColor);
            int n10 = n2 + n4 - 1;
            graphics2D.drawLine(0, n10, n7, n10);
        }
        Color color2 = this.getDefaultRowForeground(n, bl2, bl);
        graphics2D.setColor(color2);
        for (int i = 0; i < n9; ++i) {
            TreeColumn treeColumn = this.mColumns.get(i);
            int n11 = treeColumn.getWidth();
            if (i == n9 - 1) {
                n11 = Math.max(n11, n7 - n5);
            }
            if (n5 + n11 > n6 && n5 < n7) {
                int n12 = n5;
                graphics2D.clipRect(n5, n2, n11, n4);
                Composite composite = null;
                if (this.mSourceDragColumn == treeColumn) {
                    composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                if (i == 0) {
                    int n13;
                    int n14;
                    Object object;
                    int n15 = treeRow.getDepth();
                    int n16 = 25 * n15;
                    n11 -= n16;
                    n12 += n16;
                    if ((this.mShowDisclosureControls || n15 > 0) && this.mHierarchyLineColor != null && (treeRow != (object = this.mRoot.getChild(0)) || this.mRoot.getChildCount() > 1 || object instanceof TreeContainerRow)) {
                        Stroke stroke = graphics2D.getStroke();
                        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f));
                        n14 = n5 + n16 - 12;
                        graphics2D.setColor(this.mHierarchyLineColor);
                        graphics2D.drawLine(n14, n2 + n3 / 2, n5 + n16, n2 + n3 / 2);
                        n13 = treeRow != object ? n2 : n2 + n3 / 2;
                        int n17 = n2 + (treeRow.getIndex() != treeRow.getParent().getChildCount() - 1 ? n4 : n3 / 2);
                        if (n13 != n17) {
                            graphics2D.drawLine(n14, n13, n14, n17);
                        }
                        for (TreeContainerRow treeContainerRow = treeRow.getParent(); treeContainerRow != this.mRoot; treeContainerRow = treeContainerRow.getParent()) {
                            n14 -= 25;
                            if (treeContainerRow.getIndex() == treeContainerRow.getParent().getChildCount() - 1) continue;
                            graphics2D.drawLine(n14, n2, n14, n2 + n4);
                        }
                        graphics2D.setColor(color2);
                        graphics2D.setStroke(stroke);
                    }
                    if (this.mShowDisclosureControls && treeRow instanceof TreeContainerRow) {
                        object = this.isOpen((TreeContainerRow)treeRow) ? ToolkitImage.getCollapseIcon() : ToolkitImage.getExpandIcon();
                        int n18 = ((BufferedImage)object).getWidth();
                        n14 = n3 - ((BufferedImage)object).getHeight();
                        if ((n14 & 1) == 1) {
                            ++n14;
                        }
                        n14 = n2 + n14 / 2;
                        n13 = 25 - n18;
                        if ((n13 & 1) == 0) {
                            --n13;
                        }
                        n13 = n5 + n16 - (n18 + n13 / 2);
                        graphics2D.drawImage((Image)object, n13, n14, null);
                    }
                }
                treeColumn.draw(graphics2D, this, treeRow, n, n2, n12, n11, bl2, bl);
                if (this.mSourceDragColumn == treeColumn) {
                    graphics2D.setComposite(composite);
                }
                graphics2D.setClip(shape);
            }
            n5 += treeColumn.getWidth() + n8;
        }
        graphics2D.setColor(color);
    }

    public int getColumnDividerPosition(int n) {
        int n2 = this.getColumnDividerWidth();
        int n3 = 0;
        for (int i = 0; i <= n; ++i) {
            n3 += this.mColumns.get(i).getWidth() + n2;
        }
        return n3 - n2;
    }

    public int overColumnDivider(int n) {
        int n2 = this.getColumnDividerWidth();
        int n3 = this.mColumns.size() - 1;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            TreeColumn treeColumn = this.mColumns.get(i);
            if (n >= (n4 += treeColumn.getWidth()) - 4 && n <= n4 + 4) {
                return i;
            }
            n4 += n2;
        }
        return -1;
    }

    public TreeContainerRow overDisclosureControl(int n, int n2) {
        int n3;
        TreeRow treeRow;
        if (this.mShowDisclosureControls && !this.mColumns.isEmpty() && n < this.mColumns.get(0).getWidth() + this.getColumnDividerWidth() && (treeRow = this.overRow(n2)) instanceof TreeContainerRow && n <= (n3 = 25 * treeRow.getDepth()) && n >= n3 - 25) {
            return (TreeContainerRow)treeRow;
        }
        return null;
    }

    public void repaintRows(TreeRow ... treeRowArray) {
        this.repaintRows(Arrays.asList(treeRowArray));
    }

    public void repaintRows(Collection<TreeRow> collection) {
        HashSet<TreeRow> hashSet = new HashSet<TreeRow>(collection);
        Rectangle rectangle = this.getContentViewBounds();
        int n = rectangle.y;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.x;
        int n4 = rectangle.width;
        int n5 = 0;
        int n6 = this.getRowDividerHeight();
        for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            int n7 = this.getRowHeight(treeRow) + n6;
            if (n5 + n7 > n && hashSet.contains(treeRow)) {
                this.repaintContentView(n3, n5, n4, n7);
                hashSet.remove(treeRow);
                if (hashSet.isEmpty()) break;
            }
            if ((n5 += n7) < n2) continue;
            break;
        }
    }

    public Rectangle getRowBounds(TreeRow treeRow) {
        int n = 0;
        int n2 = this.getRowDividerHeight();
        for (TreeRow treeRow2 : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            int n3 = this.getRowHeight(treeRow2) + n2;
            if (treeRow2 == treeRow) {
                return new Rectangle(0, n, this.getContentSize().width, n3);
            }
            n += n3;
        }
        return null;
    }

    public TreeColumn overColumn(int n) {
        if (n >= 0 && !this.mColumns.isEmpty()) {
            int n2 = this.getColumnDividerWidth();
            int n3 = this.mColumns.size() - 1;
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                TreeColumn treeColumn = this.mColumns.get(i);
                if (n >= (n4 += treeColumn.getWidth() + n2)) continue;
                return treeColumn;
            }
            return this.mColumns.get(n3);
        }
        return null;
    }

    public TreeRow overRow(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = this.getRowDividerHeight();
        for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            if ((n -= this.getRowHeight(treeRow) + n2) >= 0) continue;
            return treeRow;
        }
        return null;
    }

    public Color getRowDividerColor() {
        return this.mRowDividerColor;
    }

    public void setRowDividerColor(Color color) {
        boolean bl;
        boolean bl2 = bl = this.mRowDividerColor == null;
        if (bl ? color != null : !this.mRowDividerColor.equals(color)) {
            this.mRowDividerColor = color;
            this.notify("tree.row.divider", bl == (color == null));
            if (bl != (color == null)) {
                this.invalidateAllRowHeights();
            }
        }
    }

    public int getRowDividerHeight() {
        return this.mRowDividerColor != null ? 1 : 0;
    }

    public Color getColumnDividerColor() {
        return this.mColumnDividerColor;
    }

    public void setColumnDividerColor(Color color) {
        boolean bl;
        boolean bl2 = bl = this.mColumnDividerColor == null;
        if (bl ? color != null : !this.mColumnDividerColor.equals(color)) {
            this.mColumnDividerColor = color;
            this.notify("tree.column.divider", bl == (color == null));
        }
    }

    public int getColumnDividerWidth() {
        return this.mColumnDividerColor != null ? 1 : 0;
    }

    public Color getHierarchyLineColor() {
        return this.mHierarchyLineColor;
    }

    public void setHierarchyLineColor(Color color) {
        this.mHierarchyLineColor = color;
    }

    public Color getDefaultRowForeground(int n, boolean bl, boolean bl2) {
        if (bl) {
            Color color = UIManager.getColor("List.selectionForeground");
            if (!bl2) {
                Color color2 = this.getDefaultRowBackground(n, bl, bl2);
                boolean bl3 = Colors.threshold(color, 50);
                if (bl3 == Colors.threshold(color2, 50)) {
                    return bl3 ? Color.BLACK : Color.WHITE;
                }
            }
            return color;
        }
        return UIManager.getColor("List.foreground");
    }

    public Color getDefaultRowBackground(int n, boolean bl, boolean bl2) {
        if (bl) {
            Color color = UIManager.getColor("List.selectionBackground");
            if (!bl2) {
                color = Colors.lighter(color, 50);
            }
            return color;
        }
        return this.mUseBanding ? Colors.getBanding(n % 2 == 0) : Color.WHITE;
    }

    public boolean useBanding() {
        return this.mUseBanding;
    }

    public void setUseBanding(boolean bl) {
        this.mUseBanding = bl;
    }

    public boolean areDisclosureControlsShowing() {
        return this.mShowDisclosureControls;
    }

    public void setDisclosureControlsShowing(boolean bl) {
        this.mShowDisclosureControls = bl;
    }

    public boolean isOpen(TreeContainerRow treeContainerRow) {
        return this.mOpenRows.contains(treeContainerRow);
    }

    public void setOpen(boolean bl, TreeContainerRow ... treeContainerRowArray) {
        this.setOpen(bl, Arrays.asList(treeContainerRowArray));
    }

    public void setOpen(boolean bl, Collection<TreeContainerRow> collection) {
        HashSet<TreeContainerRow> hashSet = new HashSet<TreeContainerRow>();
        for (TreeContainerRow treeContainerRowArray : collection) {
            if (treeContainerRowArray.getTreeRoot() != this.mRoot || this.mOpenRows.contains(treeContainerRowArray) == bl) continue;
            hashSet.add(treeContainerRowArray);
        }
        if (!hashSet.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            TreeContainerRow[] treeContainerRowArray = hashSet.toArray(new TreeContainerRow[hashSet.size()]);
            if (bl) {
                this.mOpenRows.addAll(hashSet);
            } else {
                for (TreeContainerRow treeContainerRow : treeContainerRowArray) {
                    for (TreeRow treeRow : new TreeRowViewIterator(this, treeContainerRow.getChildren())) {
                        if (!this.mSelectedRows.contains(treeRow)) continue;
                        arrayList.add(treeRow);
                    }
                }
                this.mOpenRows.removeAll(hashSet);
            }
            this.notify(bl ? "tree.row.opened" : "tree.row.closed", treeContainerRowArray);
            if (!arrayList.isEmpty()) {
                TreeRow[] treeRowArray = this.mSelectedRows.toArray(new TreeRow[this.mSelectedRows.size()]);
                this.mSelectedRows.removeAll(arrayList);
                if (this.mAnchorRow != null && !this.mSelectedRows.contains(this.mAnchorRow)) {
                    this.mAnchorRow = this.getFirstSelectedRow();
                }
                this.notify("tree.row.selection", treeRowArray);
            }
            this.repaintContentView();
            this.DEFERRED_RESIZER.run();
        }
    }

    public boolean isSelected(TreeRow treeRow) {
        return this.mSelectedRows.contains(treeRow);
    }

    public boolean isRowOrAncestorSelected(TreeRow treeRow) {
        return this.mSelectedRows.contains(treeRow) || this.isAncestorSelected(treeRow);
    }

    public boolean isAncestorSelected(TreeRow treeRow) {
        for (treeRow = treeRow.getParent(); treeRow != null; treeRow = treeRow.getParent()) {
            if (!this.mSelectedRows.contains(treeRow)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canSelectAll() {
        for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            if (this.mSelectedRows.contains(treeRow)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void selectAll() {
        TreeRow[] treeRowArray = this.mSelectedRows.toArray(new TreeRow[this.mSelectedRows.size()]);
        boolean bl = false;
        this.mAnchorRow = null;
        for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            if (this.mAnchorRow == null) {
                this.mAnchorRow = treeRow;
            }
            if (!this.mSelectedRows.add(treeRow)) continue;
            bl = true;
        }
        if (bl) {
            this.repaintContentView();
            this.notify("tree.row.selection", treeRowArray);
        }
    }

    public void select(TreeRow treeRow, boolean bl) {
        TreeRow[] treeRowArray = this.mSelectedRows.toArray(new TreeRow[this.mSelectedRows.size()]);
        boolean bl2 = false;
        if (!bl) {
            bl2 = !this.mSelectedRows.isEmpty();
            this.repaintRows(this.mSelectedRows);
            this.mSelectedRows.clear();
        }
        if (this.mSelectedRows.isEmpty()) {
            this.mAnchorRow = treeRow;
        }
        if (!this.mSelectedRows.contains(treeRow)) {
            this.mSelectedRows.add(treeRow);
            bl2 = true;
        }
        if (bl2) {
            this.repaintRows(this.mSelectedRows);
            this.notify("tree.row.selection", treeRowArray);
        }
    }

    public void select(TreeRow treeRow, TreeRow treeRow2, boolean bl) {
        if (treeRow == treeRow2) {
            this.select(treeRow, bl);
        } else {
            TreeRow[] treeRowArray = this.mSelectedRows.toArray(new TreeRow[this.mSelectedRows.size()]);
            if (!bl) {
                this.repaintRows(this.mSelectedRows);
                this.mSelectedRows.clear();
            }
            if (this.mSelectedRows.isEmpty()) {
                this.mAnchorRow = treeRow;
            }
            boolean bl2 = false;
            for (TreeRow treeRow3 : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
                if (bl2) {
                    this.mSelectedRows.add(treeRow3);
                    if (treeRow3 != treeRow2) continue;
                    break;
                }
                if (treeRow3 == treeRow) {
                    bl2 = true;
                    this.mSelectedRows.add(treeRow3);
                    continue;
                }
                if (treeRow3 != treeRow2) continue;
                bl2 = true;
                this.mSelectedRows.add(treeRow3);
                treeRow2 = treeRow;
            }
            this.repaintRows(this.mSelectedRows);
            this.notify("tree.row.selection", treeRowArray);
        }
    }

    public void deselect() {
        if (!this.mSelectedRows.isEmpty()) {
            TreeRow[] treeRowArray = this.mSelectedRows.toArray(new TreeRow[this.mSelectedRows.size()]);
            this.repaintRows(this.mSelectedRows);
            this.mSelectedRows.clear();
            this.mAnchorRow = null;
            this.notify("tree.row.selection", treeRowArray);
        }
    }

    public void deselect(TreeRow treeRow) {
        if (this.mSelectedRows.contains(treeRow)) {
            TreeRow[] treeRowArray = this.mSelectedRows.toArray(new TreeRow[this.mSelectedRows.size()]);
            this.mSelectedRows.remove(treeRow);
            if (this.mAnchorRow == treeRow) {
                this.mAnchorRow = this.getFirstSelectedRow();
            }
            this.repaintRows(treeRow);
            this.notify("tree.row.selection", treeRowArray);
        }
    }

    public TreeRow selectUp(boolean bl) {
        TreeRow treeRow = null;
        if (this.mRoot.getChildCount() > 0) {
            int n = this.mSelectedRows.size();
            if (bl && n > 0) {
                treeRow = this.getLastSelectedRow();
                if (treeRow == this.mAnchorRow) {
                    treeRow = this.getBeforeFirstSelectedRow();
                    if (treeRow != null) {
                        this.select(treeRow, true);
                    }
                } else {
                    this.deselect(treeRow);
                    treeRow = this.getLastSelectedRow();
                }
            } else {
                if (n == 0) {
                    treeRow = this.getLastDisclosedRow();
                } else {
                    TreeRow treeRow2 = treeRow = n == 1 ? this.getBeforeFirstSelectedRow() : this.getFirstSelectedRow();
                    if (treeRow == null) {
                        treeRow = this.getFirstRow();
                    }
                }
                if (treeRow != null) {
                    this.select(treeRow, false);
                }
            }
        }
        return treeRow;
    }

    public TreeRow selectDown(boolean bl) {
        TreeRow treeRow = null;
        if (this.mRoot.getChildCount() > 0) {
            int n = this.mSelectedRows.size();
            if (bl && n > 0) {
                treeRow = this.getFirstSelectedRow();
                if (treeRow == this.mAnchorRow) {
                    treeRow = this.getAfterLastSelectedRow();
                    if (treeRow != null) {
                        this.select(treeRow, true);
                    }
                } else {
                    this.deselect(treeRow);
                    treeRow = this.getFirstSelectedRow();
                }
            } else {
                if (n == 0) {
                    treeRow = this.getFirstRow();
                } else {
                    TreeRow treeRow2 = treeRow = n == 1 ? this.getAfterLastSelectedRow() : this.getLastSelectedRow();
                    if (treeRow == null) {
                        treeRow = this.getLastDisclosedRow();
                    }
                }
                if (treeRow != null) {
                    this.select(treeRow, false);
                }
            }
        }
        return treeRow;
    }

    public TreeRow selectToHome(boolean bl) {
        TreeRow treeRow = null;
        if (this.mRoot.getChildCount() > 0) {
            treeRow = this.getFirstRow();
            if (bl && !this.mSelectedRows.isEmpty()) {
                if (this.mAnchorRow == null) {
                    this.mAnchorRow = this.getLastSelectedRow();
                }
                this.select(treeRow, this.mAnchorRow, true);
            } else {
                this.select(treeRow, false);
            }
        }
        return treeRow;
    }

    public TreeRow selectToEnd(boolean bl) {
        TreeRow treeRow = null;
        if (this.mRoot.getChildCount() > 0) {
            treeRow = this.getLastDisclosedRow();
            if (bl && !this.mSelectedRows.isEmpty()) {
                if (this.mAnchorRow == null) {
                    this.mAnchorRow = this.getFirstSelectedRow();
                }
                this.select(this.mAnchorRow, treeRow, true);
            } else {
                this.select(treeRow, false);
            }
        }
        return treeRow;
    }

    public TreeRow getFirstRow() {
        List<TreeRow> list = this.mRoot.getChildren();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TreeRow getLastDisclosedRow() {
        return this.getLastChild(this.mRoot);
    }

    private TreeRow getLastChild(TreeRow treeRow) {
        if (treeRow instanceof TreeContainerRow) {
            TreeContainerRow treeContainerRow = (TreeContainerRow)treeRow;
            if (treeRow instanceof TreeRoot || this.isOpen(treeContainerRow)) {
                List<TreeRow> list = treeContainerRow.getChildren();
                int n = list.size();
                if (n > 0) {
                    return this.getLastChild(list.get(n - 1));
                }
                return treeRow instanceof TreeRoot ? null : treeRow;
            }
        }
        return treeRow;
    }

    private TreeRow getBeforeFirstSelectedRow() {
        TreeRow treeRow = null;
        for (TreeRow treeRow2 : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            if (this.mSelectedRows.contains(treeRow2)) {
                return treeRow;
            }
            treeRow = treeRow2;
        }
        return null;
    }

    public ArrayList<TreeRow> getSelectedRows() {
        ArrayList<TreeRow> arrayList = new ArrayList<TreeRow>();
        if (!this.mSelectedRows.isEmpty()) {
            for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
                if (!this.mSelectedRows.contains(treeRow) || this.isAncestorSelected(treeRow)) continue;
                arrayList.add(treeRow);
            }
        }
        return arrayList;
    }

    public TreeRow getFirstSelectedRow() {
        if (!this.mSelectedRows.isEmpty()) {
            for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
                if (!this.mSelectedRows.contains(treeRow)) continue;
                return treeRow;
            }
        }
        return null;
    }

    public TreeRow getLastSelectedRow() {
        if (!this.mSelectedRows.isEmpty()) {
            HashSet<TreeRow> hashSet = new HashSet<TreeRow>(this.mSelectedRows);
            for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
                if (!hashSet.contains(treeRow)) continue;
                hashSet.remove(treeRow);
                if (!hashSet.isEmpty()) continue;
                return treeRow;
            }
        }
        return null;
    }

    private TreeRow getAfterLastSelectedRow() {
        if (!this.mSelectedRows.isEmpty()) {
            HashSet<TreeRow> hashSet = new HashSet<TreeRow>(this.mSelectedRows);
            for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
                if (hashSet.isEmpty()) {
                    return treeRow;
                }
                if (!hashSet.contains(treeRow)) continue;
                hashSet.remove(treeRow);
            }
        }
        return null;
    }

    private ArrayList<TreeContainerRow> getTreeContainerRows(Collection<TreeRow> collection) {
        ArrayList<TreeContainerRow> arrayList = new ArrayList<TreeContainerRow>();
        for (TreeRow treeRow : collection) {
            if (!(treeRow instanceof TreeContainerRow)) continue;
            arrayList.add((TreeContainerRow)treeRow);
        }
        return arrayList;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: {
                this.setOpen(false, this.getTreeContainerRows(this.mSelectedRows));
                break;
            }
            case 39: {
                this.setOpen(true, this.getTreeContainerRows(this.mSelectedRows));
                break;
            }
            case 38: {
                this.keyScroll(this.selectUp(keyEvent.isShiftDown()));
                break;
            }
            case 40: {
                this.keyScroll(this.selectDown(keyEvent.isShiftDown()));
                break;
            }
            case 36: {
                this.keyScroll(this.selectToHome(keyEvent.isShiftDown()));
                break;
            }
            case 35: {
                this.keyScroll(this.selectToEnd(keyEvent.isShiftDown()));
                break;
            }
            default: {
                return;
            }
        }
        keyEvent.consume();
    }

    private void keyScroll(TreeRow treeRow) {
        if (treeRow != null) {
            Rectangle rectangle = this.getRowBounds(treeRow);
            Rectangle rectangle2 = this.getContentViewBounds();
            rectangle.x = rectangle2.x;
            rectangle.width = 1;
            this.scrollContentIntoView(rectangle);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n' || c == '\r') {
            if (this.canOpenSelection()) {
                this.openSelection();
            }
            keyEvent.consume();
        } else if (c == '\b' || c == '\u007f') {
            if (this.canDeleteSelection()) {
                this.deleteSelection();
            }
            keyEvent.consume();
        }
    }

    public Deletable getDeletableProxy() {
        return this.mDeletableProxy;
    }

    public void setDeletableProxy(Deletable deletable) {
        this.mDeletableProxy = deletable;
    }

    @Override
    public boolean canDeleteSelection() {
        if (this.mDeletableProxy != null && !this.mSelectedRows.isEmpty()) {
            return this.mDeletableProxy.canDeleteSelection();
        }
        return false;
    }

    @Override
    public void deleteSelection() {
        if (this.mDeletableProxy != null && !this.mSelectedRows.isEmpty()) {
            this.mDeletableProxy.deleteSelection();
        }
    }

    public Openable getOpenableProxy() {
        return this.mOpenableProxy;
    }

    public void setOpenableProxy(Openable openable) {
        this.mOpenableProxy = openable;
    }

    @Override
    public boolean canOpenSelection() {
        if (this.mOpenableProxy != null && !this.mSelectedRows.isEmpty()) {
            return this.mOpenableProxy.canOpenSelection();
        }
        return false;
    }

    @Override
    public void openSelection() {
        if (this.mOpenableProxy != null && !this.mSelectedRows.isEmpty()) {
            this.mOpenableProxy.openSelection();
        }
    }

    private void notify(String string, Object object) {
        this.mRoot.getNotifier().notify(this, string, object);
    }

    @Override
    public int getNotificationPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void handleNotification(Object object, String string, Object object2) {
        if (string == "tree.row.removed") {
            for (TreeRow treeRow : new TreeRowIterator((TreeRow[])object2)) {
                this.mSelectedRows.remove(treeRow);
                if (treeRow instanceof TreeContainerRow) {
                    this.mOpenRows.remove(treeRow);
                }
                if (this.mRowHeight >= 1) continue;
                this.mRowHeightMap.remove((Object)treeRow);
            }
        }
    }

    public TreeColumn getSourceDragColumn() {
        return this.mSourceDragColumn;
    }

    protected void setSourceDragColumn(TreeColumn treeColumn) {
        if (this.mSourceDragColumn != null) {
            this.repaintColumn(this.mSourceDragColumn);
        }
        this.mSourceDragColumn = treeColumn;
        if (this.mSourceDragColumn != null) {
            this.repaintColumn(this.mSourceDragColumn);
        }
    }

    public void repaintColumn(TreeColumn treeColumn) {
        Point point = this.fromHeaderView(new Point(this.getColumnStart(treeColumn), 0));
        Rectangle rectangle = new Rectangle(point.x, 0, treeColumn.getWidth(), this.getHeight());
        this.repaint(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createColumnDragImage(TreeColumn treeColumn) {
        Graphics graphics = null;
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = this.createImage();
        try {
            int n = treeColumn.getWidth();
            int n2 = this.getHeight();
            bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(n, n2, 3);
            graphics = (Graphics2D)bufferedImage.getGraphics();
            graphics.setClip(new Rectangle(0, 0, n, n2));
            ((Graphics2D)graphics).setBackground(new Color(0, true));
            graphics.clearRect(0, 0, n, n2);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.5f));
            Point point = this.fromHeaderView(new Point());
            graphics.drawImage(bufferedImage2, -(this.getColumnStart(treeColumn) + point.x), 0, this);
        }
        catch (Exception exception) {
            assert (false) : Debug.throwableToString(exception);
            bufferedImage = null;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return bufferedImage != null ? bufferedImage : bufferedImage2;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.mDropReceived = false;
        int n = dragGestureEvent.getDragAction();
        Point point = new Point(dragGestureEvent.getDragOrigin());
        switch (this.checkAndConvertToArea(point)) {
            case CONTENT: {
                if (this.mDragColumnDivider != -1 || this.mSelectedRows.isEmpty() || (n & this.mAllowedRowDragTypes) == 0) break;
                TreeRowSelection treeRowSelection = new TreeRowSelection(this.getSelectedRows(), this.mOpenRows);
                if (DragSource.isDragImageSupported()) {
                    BufferedImage bufferedImage = this.createDragImage(point);
                    Rectangle rectangle = this.getDragClip();
                    Point point2 = rectangle != null ? new Point(rectangle.x - point.x, rectangle.y - point.y) : new Point();
                    dragGestureEvent.startDrag(null, bufferedImage, point2, treeRowSelection, this);
                    break;
                }
                dragGestureEvent.startDrag(null, treeRowSelection, this);
                break;
            }
            case HEADER: {
                if (this.mAllowColumnDrag && n == 2 && this.mSortColumn != null) {
                    this.setSourceDragColumn(this.mSortColumn);
                    if (DragSource.isDragImageSupported()) {
                        dragGestureEvent.startDrag(null, this.createColumnDragImage(this.mSortColumn), new Point(-(point.x - this.getColumnStart(this.mSortColumn)), -point.y), this.mSortColumn, this);
                    } else {
                        dragGestureEvent.startDrag(null, this.mSortColumn, this);
                    }
                }
                this.mSortColumn = null;
                break;
            }
        }
    }

    protected TreeDragState checkDragAcceptability(DropTargetDragEvent dropTargetDragEvent) {
        block4: {
            try {
                ArrayList<TreeRow> arrayList;
                Transferable transferable;
                if (dropTargetDragEvent.isDataFlavorSupported(TreeColumn.DATA_FLAVOR) && (transferable = (TreeColumn)dropTargetDragEvent.getTransferable().getTransferData(TreeColumn.DATA_FLAVOR)) != null && this.isColumnDragAcceptable(dropTargetDragEvent, (TreeColumn)transferable)) {
                    return new TreeColumnDragState(this, (TreeColumn)transferable);
                }
                if (dropTargetDragEvent.isDataFlavorSupported(TreeRowSelection.DATA_FLAVOR) && (transferable = (TreeRowSelection)dropTargetDragEvent.getTransferable().getTransferData(TreeRowSelection.DATA_FLAVOR)) != null && (arrayList = ((TreeRowSelection)transferable).getRows()).size() != 0 && this.isRowDragAcceptable(dropTargetDragEvent, arrayList)) {
                    return new TreeRowDragState(this, (TreeRowSelection)transferable);
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)Debug.throwableToString(exception));
            }
        }
        return null;
    }

    protected boolean isColumnDragAcceptable(DropTargetDragEvent dropTargetDragEvent, TreeColumn treeColumn) {
        return this.mColumns.contains(treeColumn);
    }

    protected boolean isRowDragAcceptable(DropTargetDragEvent dropTargetDragEvent, ArrayList<TreeRow> arrayList) {
        return this.mAllowRowDropFromExternal ? true : arrayList.get(0).getTreeRoot() == this.mRoot;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.mDragState = this.checkDragAcceptability(dropTargetDragEvent);
        if (this.mDragState != null) {
            this.redrawDragHighlight(this.mDragState.isHeaderFocus(), this.mDragState.isContentsFocus());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mDragState != null) {
            this.mDragState.dragOver(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mDragState != null) {
            this.mDragState.dropActionChanged(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.mDragState != null) {
            this.mDragState.dragExit(dropTargetEvent);
        }
        this.clearDragState();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.mDragState != null) {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            this.mDropReceived = true;
            dropTargetDropEvent.dropComplete(this.mDragState.drop(dropTargetDropEvent));
        } else {
            this.mDropReceived = false;
            dropTargetDropEvent.rejectDrop();
        }
        this.clearDragState();
    }

    private void clearDragState() {
        if (this.mDragState != null) {
            boolean bl = this.mDragState.isHeaderFocus();
            boolean bl2 = this.mDragState.isContentsFocus();
            this.mDragState = null;
            this.redrawDragHighlight(bl, bl2);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess() && !this.mDropReceived && (dragSourceDropEvent.getDropAction() & this.mAllowedRowDragTypes) == 2) {
            this.externalMoveDrop(dragSourceDropEvent.getDragSourceContext().getTransferable());
        }
        this.setSourceDragColumn(null);
    }

    protected void externalMoveDrop(Transferable transferable) {
        if (transferable.isDataFlavorSupported(TreeRowSelection.DATA_FLAVOR)) {
            this.deleteSelection();
        }
    }

    private void redrawDragHighlight(boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle rectangle;
        if (bl) {
            rectangle = this.getHeaderViewBounds();
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = rectangle.width;
            n = rectangle.height;
            this.paintHeaderViewImmediately(n4, n3, n2, 3);
            this.paintHeaderViewImmediately(n4, n3 + n - 3, n2, 3);
            this.paintHeaderViewImmediately(n4, n3 + 3, 3, n - 6);
            this.paintHeaderViewImmediately(n4 + n2 - 3, n3 + 3, 3, n - 6);
        }
        if (bl2) {
            rectangle = this.getContentViewBounds();
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = rectangle.width;
            n = rectangle.height;
            this.paintContentViewImmediately(n4, n3, n2, 3);
            this.paintContentViewImmediately(n4, n3 + n - 3, n2, 3);
            this.paintContentViewImmediately(n4, n3 + 3, 3, n - 6);
            this.paintContentViewImmediately(n4 + n2 - 3, n3 + 3, 3, n - 6);
        }
    }

    protected void adjustInsertionMarker(TreeContainerRow treeContainerRow, int n) {
        if (this.mDragState instanceof TreeRowDragState) {
            TreeRowDragState treeRowDragState = (TreeRowDragState)this.mDragState;
            TreeContainerRow treeContainerRow2 = treeRowDragState.getParentRow();
            int n2 = treeRowDragState.getChildInsertIndex();
            if (treeContainerRow2 != treeContainerRow || n2 != n) {
                int n3;
                treeRowDragState.setParentRow(treeContainerRow);
                treeRowDragState.setChildInsertIndex(n);
                Rectangle rectangle = this.getContentViewBounds();
                if (treeContainerRow2 != null && n2 >= 0) {
                    n3 = this.getInsertionMarkerPosition(treeContainerRow2, n2);
                    this.paintContentViewImmediately(rectangle.x, n3 - 1, rectangle.width, 3);
                }
                if (treeContainerRow != null && n >= 0) {
                    n3 = this.getInsertionMarkerPosition(treeContainerRow, n);
                    this.paintContentViewImmediately(rectangle.x, n3 - 1, rectangle.width, 3);
                }
            }
        }
    }

    private int getInsertionMarkerPosition(TreeContainerRow treeContainerRow, int n) {
        int n2 = 0;
        int n3 = this.getRowDividerHeight();
        if (this.mRoot != treeContainerRow) {
            for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
                n2 += this.getRowHeight(treeRow) + n3;
                if (treeRow != treeContainerRow) continue;
                break;
            }
        }
        if (n > 0) {
            for (TreeRow treeRow : new TreeRowViewIterator(this, treeContainerRow.getChildren())) {
                n2 += this.getRowHeight(treeRow) + n3;
                if (treeRow.getParent() != treeContainerRow || --n != 0) continue;
                break;
            }
        }
        return n2 > 0 ? n2 - 1 : 0;
    }

    public int getPreferredColumnWidth(TreeColumn treeColumn) {
        Dimension dimension = treeColumn.calculatePreferredHeaderSize(this);
        boolean bl = treeColumn == this.mColumns.get(0);
        for (TreeRow treeRow : new TreeRowViewIterator(this, this.mRoot.getChildren())) {
            int n = treeColumn.calculatePreferredWidth(treeRow);
            if (bl) {
                n += treeRow.getDepth() * 25;
            }
            if (n <= dimension.width) continue;
            dimension.width = n;
        }
        return dimension.width;
    }

    public void sizeColumnToFit(TreeColumn treeColumn) {
        int n = this.getPreferredColumnWidth(treeColumn);
        if (n != treeColumn.getWidth()) {
            treeColumn.setWidth(n);
            this.invalidateAllRowHeights();
            this.DEFERRED_RESIZER.run();
            this.repaint();
        }
    }

    public void sizeColumnsToFit() {
        boolean bl = false;
        for (TreeColumn treeColumn : this.mColumns) {
            int n = this.getPreferredColumnWidth(treeColumn);
            if (n == treeColumn.getWidth()) continue;
            treeColumn.setWidth(n);
            bl = true;
        }
        if (bl) {
            this.invalidateAllRowHeights();
            this.DEFERRED_RESIZER.run();
            this.repaint();
        }
    }
}

