/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.widgets.tree.TreeContainerRow;
import com.trollworks.ttk.widgets.tree.TreeRoot;

public class TreeRow
implements Cloneable {
    protected TreeContainerRow mParent;
    private int mIndex;

    protected TreeRow clone() {
        try {
            TreeRow treeRow = (TreeRow)super.clone();
            treeRow.mParent = null;
            treeRow.mIndex = 0;
            return treeRow;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public TreeContainerRow getParent() {
        return this.mParent;
    }

    public int getIndex() {
        if (this.mParent != null) {
            return this.mIndex;
        }
        return -1;
    }

    void setIndex(int n) {
        this.mIndex = n;
    }

    public boolean isDescendantOf(TreeContainerRow treeContainerRow) {
        TreeContainerRow treeContainerRow2 = this.mParent;
        while (treeContainerRow2 != null) {
            if (treeContainerRow2 == treeContainerRow) {
                return true;
            }
            treeContainerRow2 = treeContainerRow2.mParent;
        }
        return false;
    }

    public int getDepth() {
        TreeContainerRow treeContainerRow = this.mParent;
        int n = 0;
        while (treeContainerRow != null) {
            ++n;
            treeContainerRow = treeContainerRow.mParent;
        }
        return n;
    }

    public TreeRoot getTreeRoot() {
        TreeRow treeRow = this;
        while (treeRow != null) {
            if (treeRow instanceof TreeRoot) {
                return (TreeRoot)treeRow;
            }
            treeRow = treeRow.mParent;
        }
        return null;
    }

    public void notify(String string) {
        this.notify(string, null);
    }

    public void notify(String string, Object object) {
        TreeRoot treeRoot = this.getTreeRoot();
        if (treeRoot != null) {
            treeRoot.getNotifier().notify(this, string, object);
        }
    }
}

