/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.widgets.tree.TreeContainerRow;
import com.trollworks.ttk.widgets.tree.TreeDragState;
import com.trollworks.ttk.widgets.tree.TreePanel;
import com.trollworks.ttk.widgets.tree.TreeRoot;
import com.trollworks.ttk.widgets.tree.TreeRow;
import com.trollworks.ttk.widgets.tree.TreeRowIterator;
import com.trollworks.ttk.widgets.tree.TreeRowSelection;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.HashSet;

public class TreeRowDragState
extends TreeDragState {
    private TreeRowSelection mRowSelection;
    private TreeContainerRow mParentRow;
    private int mChildInsertIndex;

    public TreeRowDragState(TreePanel treePanel, TreeRowSelection treeRowSelection) {
        super(treePanel);
        this.mRowSelection = treeRowSelection;
        this.setContentsFocus(true);
    }

    public TreeContainerRow getParentRow() {
        return this.mParentRow;
    }

    public void setParentRow(TreeContainerRow treeContainerRow) {
        this.mParentRow = treeContainerRow;
    }

    public int getChildInsertIndex() {
        return this.mChildInsertIndex;
    }

    public void setChildInsertIndex(int n) {
        this.mChildInsertIndex = n;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.acceptDrag(dropTargetDragEvent);
    }

    private boolean acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        int n = this.getPanel().getAllowedRowDropTypes();
        if ((n & dropTargetDragEvent.getDropAction()) == 0) {
            if ((n & 2) != 0) {
                dropTargetDragEvent.acceptDrag(2);
            } else if ((n & 1) != 0) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.acceptDrag(0);
                return false;
            }
        }
        return true;
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        TreePanel treePanel = this.getPanel();
        TreeContainerRow treeContainerRow = null;
        int n = -1;
        if (this.acceptDrag(dropTargetDragEvent)) {
            Point point = treePanel.toContentView(new Point(dropTargetDragEvent.getLocation()));
            TreeRoot treeRoot = treePanel.getRoot();
            TreeRow treeRow = treePanel.overRow(point.y);
            if (treeRow != null) {
                if (this.mRowSelection.getRows().get(0).getTreeRoot() != treeRoot || !treePanel.isRowOrAncestorSelected(treeRow)) {
                    int n2 = 25 * treeRow.getDepth();
                    if (treePanel.areDisclosureControlsShowing()) {
                        n2 += 25;
                    }
                    if (treeRow instanceof TreeContainerRow && point.x > n2) {
                        treeContainerRow = (TreeContainerRow)treeRow;
                        n = 0;
                    } else {
                        treeContainerRow = treeRow.getParent();
                        n = treeRow.getIndex();
                        Rectangle rectangle = treePanel.getRowBounds(treeRow);
                        if (point.y > rectangle.y + rectangle.height / 2) {
                            ++n;
                        }
                    }
                }
            } else {
                treeContainerRow = treeRoot;
                n = treeRoot.getChildCount();
            }
        }
        treePanel.adjustInsertionMarker(treeContainerRow, n);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.getPanel().adjustInsertionMarker(null, -1);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.acceptDrag(dropTargetDragEvent);
    }

    @Override
    public boolean drop(DropTargetDropEvent dropTargetDropEvent) {
        TreeContainerRow treeContainerRow = this.mParentRow;
        if (treeContainerRow != null) {
            int n = this.mChildInsertIndex;
            TreePanel treePanel = this.getPanel();
            TreeRow treeRow = null;
            if (n < treeContainerRow.getChildCount()) {
                treeRow = treeContainerRow.getChild(n);
            }
            treePanel.adjustInsertionMarker(null, -1);
            ArrayList<TreeRow> arrayList = this.mRowSelection.getRows();
            HashSet<TreeContainerRow> hashSet = this.mRowSelection.getOpenRows();
            boolean bl = arrayList.get(0).getTreeRoot() == treePanel.getRoot();
            int n2 = dropTargetDropEvent.getDropAction() & treePanel.getAllowedRowDropTypes();
            if (n2 == 1 || !bl && n2 == 2) {
                ArrayList<TreeRow> arrayList2 = new ArrayList<TreeRow>(arrayList.size());
                for (TreeRow cloneable2 : arrayList) {
                    arrayList2.add(cloneable2.clone());
                }
                ArrayList<TreeContainerRow> arrayList3 = this.getContainers(arrayList);
                ArrayList<TreeContainerRow> treeContainerRow2 = this.getContainers(arrayList2);
                arrayList = arrayList2;
                HashSet<TreeContainerRow> n4 = new HashSet<TreeContainerRow>();
                int n3 = arrayList3.size();
                for (int i = 0; i < n3; ++i) {
                    if (!hashSet.contains(arrayList3.get(i))) continue;
                    n4.add(treeContainerRow2.get(i));
                }
                hashSet = n4;
            } else if (n2 == 2) {
                for (TreeRow treeRow2 : arrayList) {
                    TreeContainerRow treeContainerRow2 = treeRow2.getParent();
                    if (treeRow2 == treeRow) {
                        int n4 = treeRow.getIndex();
                        treeContainerRow2.removeRow(treeRow2);
                        if (n4 < treeContainerRow2.getChildCount()) {
                            treeRow = treeContainerRow2.getChild(n4);
                            continue;
                        }
                        treeRow = null;
                        continue;
                    }
                    treeContainerRow2.removeRow(treeRow2);
                }
            } else {
                return false;
            }
            n = treeRow != null ? treeRow.getIndex() : treeContainerRow.getChildCount();
            treeContainerRow.addRow(n, arrayList);
            treePanel.select(arrayList.get(0), arrayList.get(arrayList.size() - 1), false);
            treePanel.setOpen(true, hashSet);
            treePanel.getTreeSorter().clearSort();
            treePanel.pack();
            return true;
        }
        return false;
    }

    private ArrayList<TreeContainerRow> getContainers(ArrayList<TreeRow> arrayList) {
        ArrayList<TreeContainerRow> arrayList2 = new ArrayList<TreeContainerRow>();
        for (TreeRow treeRow : new TreeRowIterator(arrayList)) {
            if (!(treeRow instanceof TreeContainerRow)) continue;
            arrayList2.add((TreeContainerRow)treeRow);
        }
        return arrayList2;
    }
}

