/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.border;

import com.trollworks.ttk.text.TextDrawing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;

public class BoxedDropShadowBorder
implements Border {
    private static BoxedDropShadowBorder INSTANCE = null;
    private String mTitle;
    private Font mFont;

    public BoxedDropShadowBorder() {
    }

    public BoxedDropShadowBorder(Font font, String string) {
        this.mFont = font;
        this.mTitle = string;
    }

    public static synchronized BoxedDropShadowBorder get() {
        if (INSTANCE == null) {
            INSTANCE = new BoxedDropShadowBorder();
        }
        return INSTANCE;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Insets insets = new Insets(1, 1, 3, 3);
        if (this.mTitle != null) {
            insets.top += TextDrawing.getPreferredSize((Font)this.mFont, (String)this.mTitle).height;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3 - 3, n4 - 3);
        if (this.mTitle != null) {
            Font font = graphics.getFont();
            graphics.setFont(this.mFont);
            int n5 = TextDrawing.getPreferredSize((Font)this.mFont, (String)this.mTitle).height;
            Rectangle rectangle = new Rectangle(n, n2, n3 - 3, n5 + 2);
            graphics.fillRect(n, n2, n3 - 3, n5 + 1);
            graphics.setColor(Color.white);
            TextDrawing.draw(graphics, rectangle, this.mTitle, 0, 1);
            graphics.setFont(font);
        }
        graphics.setColor(color);
    }
}

