/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteredIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<?> mIterator;
    private T mNext;
    private Class<T> mContentClass;
    private boolean mNextValid;
    private boolean mOmitNulls;

    public FilteredIterator(Iterable<?> iterable, Class<T> clazz) {
        this(iterable, clazz, true);
    }

    public FilteredIterator(Iterable<?> iterable, Class<T> clazz, boolean bl) {
        this.mIterator = iterable.iterator();
        this.mContentClass = clazz;
        this.mOmitNulls = bl;
    }

    @Override
    public boolean hasNext() {
        if (this.mNextValid) {
            return true;
        }
        while (this.mIterator.hasNext()) {
            Object obj = this.mIterator.next();
            if (obj == null) {
                if (this.mOmitNulls) continue;
                this.mNext = null;
                this.mNextValid = true;
                return true;
            }
            if (!this.mContentClass.isInstance(obj)) continue;
            this.mNext = this.mContentClass.cast(obj);
            this.mNextValid = true;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.mNextValid && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.mNextValid = false;
        return this.mNext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

