/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.conduit;

import com.trollworks.ttk.conduit.Conduit;
import com.trollworks.ttk.conduit.ConduitMessage;
import com.trollworks.ttk.conduit.Server;
import com.trollworks.ttk.utility.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

class Client
extends Thread {
    private Server mServer;
    private Socket mClientSocket;
    private DataInputStream mClientInput;
    private DataOutputStream mClientOutput;

    Client(Server server, Socket socket) throws IOException {
        super(Conduit.class.getSimpleName() + '$' + Client.class.getSimpleName() + '#' + server.getNextClientCounter() + '@' + server.getServerSocket().getLocalSocketAddress());
        this.setPriority(5);
        this.setDaemon(true);
        this.mServer = server;
        this.mClientSocket = socket;
        this.mClientInput = new DataInputStream(socket.getInputStream());
        this.mClientOutput = new DataOutputStream(socket.getOutputStream());
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.mServer.send(new ConduitMessage(this.mClientInput));
            }
        }
        catch (Exception exception) {
            this.shutdown();
            return;
        }
    }

    void send(ConduitMessage conduitMessage) {
        try {
            conduitMessage.send(this.mClientOutput);
        }
        catch (Exception exception) {
            this.shutdown();
        }
    }

    synchronized void shutdown() {
        block2: {
            try {
                this.mClientSocket.close();
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)Debug.throwableToString(exception));
            }
        }
        this.mServer.remove(this);
    }
}

