/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.conduit;

import com.trollworks.ttk.conduit.ConduitReceiver;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConduitMessage
implements Runnable {
    private static final byte[] ID = new byte[]{35, 87, 105, 108, 107, 101, 115, 33};
    private String mUser;
    private String mID;
    private String mMessage;
    private ConduitReceiver mReceiver;

    public ConduitMessage(String string, String string2) {
        this.mUser = System.getProperty("user.name");
        this.mID = string;
        this.mMessage = string2;
    }

    public ConduitMessage(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        while (n < ID.length) {
            byte by = dataInputStream.readByte();
            if (by == ID[n]) {
                ++n;
                continue;
            }
            if (by == ID[0]) {
                n = 1;
                continue;
            }
            n = 0;
        }
        this.mUser = dataInputStream.readUTF();
        this.mID = dataInputStream.readUTF();
        this.mMessage = dataInputStream.readUTF();
    }

    void send(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(ID);
        dataOutputStream.writeUTF(this.getUser());
        dataOutputStream.writeUTF(this.getID());
        dataOutputStream.writeUTF(this.getMessage());
        dataOutputStream.flush();
    }

    void setReceiver(ConduitReceiver conduitReceiver) {
        this.mReceiver = conduitReceiver;
    }

    @Override
    public void run() {
        this.mReceiver.conduitMessageReceived(this);
    }

    public String getUser() {
        return this.mUser;
    }

    public String getID() {
        return this.mID;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public String toString() {
        return "[" + this.getUser() + " : " + this.getID() + "] " + this.getMessage();
    }
}

