/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.image;

import com.trollworks.ttk.image.ColorFilter;
import com.trollworks.ttk.image.FadeFilter;
import com.trollworks.ttk.utility.Debug;
import com.trollworks.ttk.utility.GraphicsUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public class Images {
    public static final String[] EXTENSIONS = new String[]{".png", ".gif", ".jpg"};
    private static final String COLORIZED_POSTFIX = new String(new char[]{':', 'C', '\u0016'});
    private static final String FADED_POSTFIX = new String(new char[]{':', 'F', '\u0016'});
    private static final HashSet<URL> LOCATIONS = new HashSet();
    private static final HashMap<String, BufferedImage> MAP = new HashMap();
    private static final HashMap<BufferedImage, String> REVERSE_MAP = new HashMap();
    private static final HashSet<String> FAILED_LOOKUPS = new HashSet();

    public static final synchronized void addLocation(File file) {
        block3: {
            try {
                if (file.isDirectory()) {
                    Images.addLocation(file.toURI().toURL());
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)Debug.throwableToString(exception));
            }
        }
    }

    public static final synchronized void addLocation(URL uRL) {
        if (!LOCATIONS.contains(uRL)) {
            LOCATIONS.add(uRL);
            FAILED_LOOKUPS.clear();
        }
    }

    public static final synchronized BufferedImage get(String string) {
        return Images.get(string, true);
    }

    public static final synchronized BufferedImage get(String string, boolean bl) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = bufferedImage = bl ? MAP.get(string) : null;
        if (bufferedImage == null && !FAILED_LOOKUPS.contains(string)) {
            for (URL uRL : LOCATIONS) {
                for (int i = 0; i < EXTENSIONS.length && bufferedImage == null; ++i) {
                    String string2 = string + EXTENSIONS[i];
                    try {
                        bufferedImage = Images.loadImage(new URL(uRL, string2));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bufferedImage == null) continue;
                break;
            }
            if (bufferedImage != null) {
                if (bl) {
                    MAP.put(string, bufferedImage);
                    REVERSE_MAP.put(bufferedImage, string);
                }
            } else {
                FAILED_LOOKUPS.add(string);
            }
        }
        return bufferedImage;
    }

    public static final synchronized void add(String string, BufferedImage bufferedImage) {
        MAP.put(string, bufferedImage);
        REVERSE_MAP.put(bufferedImage, string);
        FAILED_LOOKUPS.remove(string);
    }

    public static final synchronized void release(String string) {
        BufferedImage bufferedImage = MAP.remove(string);
        if (bufferedImage != null) {
            REVERSE_MAP.remove(bufferedImage);
        }
    }

    public static final BufferedImage create(int n, int n2) {
        Graphics2D graphics2D = GraphicsUtilities.getGraphics();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        graphics2D.dispose();
        graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.setBackground(new Color(0, true));
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static final BufferedImage scale(BufferedImage bufferedImage, int n, int n2) {
        double d;
        double d2;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Graphics2D graphics2D = GraphicsUtilities.getGraphics();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Image image = n3 != n || n4 != n2 ? ((d2 = (double)n3 / (double)n) > (d = (double)n4 / (double)n2) ? Images.loadToolkitImage(bufferedImage.getScaledInstance(n, -1, 4)) : Images.loadToolkitImage(bufferedImage.getScaledInstance(-1, n2, 4))) : bufferedImage;
        graphics2D.dispose();
        graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.setBackground(new Color(0, true));
        graphics2D.clearRect(0, 0, n, n2);
        if (image != null) {
            graphics2D.drawImage(image, (n - image.getWidth(null)) / 2, (n2 - image.getHeight(null)) / 2, null);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static final BufferedImage getBufferedImage(Image image) {
        if (!(image instanceof BufferedImage)) {
            Images.loadToolkitImage(image);
            return Images.createOptimizedImage(image);
        }
        return (BufferedImage)image;
    }

    private static BufferedImage createOptimizedImage(Image image) {
        Graphics2D graphics2D = GraphicsUtilities.getGraphics();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        graphics2D.dispose();
        graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.setBackground(new Color(0, true));
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static final BufferedImage rotate90(BufferedImage bufferedImage) {
        Graphics2D graphics2D = GraphicsUtilities.getGraphics();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n2, n, 3);
        graphics2D.dispose();
        graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setClip(0, 0, n2, n);
        graphics2D.setBackground(new Color(0, true));
        graphics2D.clearRect(0, 0, n2, n);
        graphics2D.rotate(Math.toRadians(90.0));
        graphics2D.drawImage((Image)bufferedImage, 0, -n, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static final BufferedImage rotate180(BufferedImage bufferedImage) {
        Graphics2D graphics2D = GraphicsUtilities.getGraphics();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n2, n, 3);
        graphics2D.dispose();
        graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.setBackground(new Color(0, true));
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.rotate(Math.toRadians(180.0));
        graphics2D.drawImage((Image)bufferedImage, -n, -n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static final BufferedImage rotate270(BufferedImage bufferedImage) {
        Graphics2D graphics2D = GraphicsUtilities.getGraphics();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n2, n, 3);
        graphics2D.dispose();
        graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setClip(0, 0, n2, n);
        graphics2D.setBackground(new Color(0, true));
        graphics2D.clearRect(0, 0, n2, n);
        graphics2D.rotate(Math.toRadians(270.0));
        graphics2D.drawImage((Image)bufferedImage, -n2, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static final BufferedImage superimpose(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return Images.superimpose(bufferedImage, bufferedImage2, (bufferedImage.getWidth() - bufferedImage2.getWidth()) / 2, (bufferedImage.getHeight() - bufferedImage2.getHeight()) / 2);
    }

    public static final BufferedImage superimpose(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage2.getWidth();
        int n6 = bufferedImage2.getHeight();
        Graphics2D graphics2D = GraphicsUtilities.getGraphics();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (n + n5 > n3) {
            n3 = n + n5;
        }
        if (n2 + n6 > n4) {
            n4 = n2 + n6;
        }
        BufferedImage bufferedImage3 = graphicsConfiguration.createCompatibleImage(n3, n4, 3);
        graphics2D.dispose();
        graphics2D = (Graphics2D)bufferedImage3.getGraphics();
        graphics2D.setClip(0, 0, n3, n4);
        graphics2D.setBackground(new Color(0, true));
        graphics2D.clearRect(0, 0, n3, n4);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.drawImage((Image)bufferedImage2, n, n2, null);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public static final BufferedImage superimposeAndName(BufferedImage bufferedImage, BufferedImage bufferedImage2, String string) {
        BufferedImage bufferedImage3 = Images.superimpose(bufferedImage, bufferedImage2);
        Images.add(string, bufferedImage3);
        return bufferedImage3;
    }

    public static final BufferedImage superimposeAndName(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, String string) {
        BufferedImage bufferedImage3 = Images.superimpose(bufferedImage, bufferedImage2, n, n2);
        Images.add(string, bufferedImage3);
        return bufferedImage3;
    }

    public static final synchronized BufferedImage createColorizedImage(BufferedImage bufferedImage, Color color) {
        String string = REVERSE_MAP.get(bufferedImage);
        BufferedImage bufferedImage2 = null;
        if (string != null) {
            string = string + color + COLORIZED_POSTFIX;
            bufferedImage2 = Images.get(string);
        }
        if (bufferedImage2 == null && (bufferedImage2 = ColorFilter.createColorizedImage(bufferedImage, color)) != null && string != null) {
            MAP.put(string, bufferedImage2);
            REVERSE_MAP.put(bufferedImage2, string);
        }
        return bufferedImage2;
    }

    public static final synchronized BufferedImage createFadedImage(BufferedImage bufferedImage, int n, boolean bl) {
        String string = REVERSE_MAP.get(bufferedImage);
        BufferedImage bufferedImage2 = null;
        if (string != null) {
            string = string + n + bl + FADED_POSTFIX;
            bufferedImage2 = Images.get(string);
        }
        if (bufferedImage2 == null && (bufferedImage2 = FadeFilter.createFadedImage(bufferedImage, n, bl)) != null && string != null) {
            MAP.put(string, bufferedImage2);
            REVERSE_MAP.put(bufferedImage2, string);
        }
        return bufferedImage2;
    }

    public static final BufferedImage createDisabledImage(BufferedImage bufferedImage) {
        return Images.createFadedImage(Images.createColorizedImage(bufferedImage, Color.white), 50, true);
    }

    public static final Image loadToolkitImage(Image image) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!toolkit.prepareImage(image, -1, -1, null)) {
            while (true) {
                int n;
                if (((n = toolkit.checkImage(image, -1, -1, null)) & 0xC0) != 0) {
                    return null;
                }
                if ((n & 0x38) != 0) break;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
        }
        return image;
    }

    public static final BufferedImage loadImage(File file) {
        try {
            return Images.loadImage(file.toURI().toURL());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final BufferedImage loadImage(URL uRL) {
        try {
            return Images.createOptimizedImage(ImageIO.read(uRL));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final BufferedImage loadImage(byte[] byArray) {
        try {
            return Images.createOptimizedImage(ImageIO.read(new ByteArrayInputStream(byArray)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final boolean writePNG(File file, BufferedImage bufferedImage, int n) {
        boolean bl;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bl = Images.writePNG(fileOutputStream, bufferedImage, n);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static final boolean writePNG(OutputStream outputStream, BufferedImage bufferedImage, int n) {
        ImageWriter imageWriter = null;
        try {
            IIOMetadata iIOMetadata;
            ImageOutputStream imageOutputStream;
            block5: {
                imageOutputStream = ImageIO.createImageOutputStream(outputStream);
                ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
                imageWriter = ImageIO.getImageWriters(imageTypeSpecifier, "png").next();
                iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, null);
                try {
                    Node node = iIOMetadata.getAsTree("javax_imageio_png_1.0");
                    IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("pHYs");
                    String string = Integer.toString((int)((double)n / 0.0254));
                    iIOMetadataNode.setAttribute("pixelsPerUnitXAxis", string);
                    iIOMetadataNode.setAttribute("pixelsPerUnitYAxis", string);
                    iIOMetadataNode.setAttribute("unitSpecifier", "meter");
                    node.appendChild(iIOMetadataNode);
                    iIOMetadata.setFromTree("javax_imageio_png_1.0", node);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)Debug.throwableToString(exception));
                }
            }
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(new IIOImage(bufferedImage, null, iIOMetadata));
            imageOutputStream.flush();
            imageWriter.dispose();
            return true;
        }
        catch (Exception exception) {
            if (imageWriter != null) {
                imageWriter.dispose();
            }
            return false;
        }
    }
}

